/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import javax.faces.FacesException;
import javax.faces.internal.ResultSetEntries;
import javax.faces.internal.ResultSetKeys;
import javax.faces.internal.ResultSetValues;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;

public class ResultSetDataModel
extends DataModel {
    private ResultSet resultSet = null;
    private int index = -1;
    private boolean isUpdated = false;

    public ResultSetDataModel() {
        this.setWrappedData(null);
    }

    public ResultSetDataModel(ResultSet resultSet) {
        ResultSetDataModel.assertScrollable(resultSet);
        this.setWrappedData(resultSet);
    }

    public int getRowCount() {
        return -1;
    }

    public Object getRowData() {
        if (this.resultSet == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException();
        }
        try {
            return new ResultSetMap(String.CASE_INSENSITIVE_ORDER);
        }
        catch (SQLException e) {
            throw new FacesException();
        }
    }

    public int getRowIndex() {
        return this.index;
    }

    public Object getWrappedData() {
        return this.resultSet;
    }

    public boolean isRowAvailable() {
        if (this.resultSet == null || this.index < 0) {
            return false;
        }
        try {
            return this.resultSet.absolute(this.index + 1);
        }
        catch (SQLException e) {
            throw new FacesException();
        }
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        if (this.isUpdated) {
            this.updateResultSetIfNeeded();
        }
        int oldIndex = this.index;
        this.index = rowIndex;
        DataModelListener[] listeners = this.getDataModelListeners();
        if (oldIndex != this.index && listeners != null) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event = new DataModelEvent(this, this.index, rowData);
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].rowSelected(event);
            }
        }
    }

    public void setWrappedData(Object data) {
        if (data == null) {
            this.setRowIndex(-1);
        } else {
            this.resultSet = (ResultSet)data;
            this.setRowIndex(0);
        }
    }

    private void updateResultSetIfNeeded() {
        try {
            if (this.resultSet != null && !this.resultSet.rowDeleted()) {
                this.resultSet.updateRow();
                this.isUpdated = false;
            }
        }
        catch (SQLException e) {
            throw new FacesException();
        }
    }

    private static void assertScrollable(ResultSet rs) {
        try {
            int type = rs.getType();
            if (type != 1005) {
                throw new IllegalArgumentException();
            }
        }
        catch (SQLException e) {
            throw new IllegalArgumentException();
        }
    }

    public class ResultSetMap
    extends TreeMap {
        private static final long serialVersionUID = 1L;
        private int mapIndex;
        private ResultSetMetaData metaData;

        public ResultSetMap(Comparator comparator) throws SQLException {
            super(comparator);
            this.mapIndex = 0;
            this.metaData = null;
            this.mapIndex = ResultSetDataModel.this.index;
            ResultSetDataModel.this.resultSet.absolute(this.mapIndex + 1);
            this.metaData = this.getMetaData();
            for (int i = 1; i <= this.metaData.getColumnCount(); ++i) {
                super.put(this.metaData.getColumnName(i), this.metaData.getColumnName(i));
            }
        }

        public boolean containsValue(Object value) {
            Object key = null;
            Iterator itr = this.keySet().iterator();
            while (itr.hasNext()) {
                key = itr.next();
                if ((key != null || value != null) && !key.equals(value)) continue;
                return true;
            }
            return false;
        }

        public Set entrySet() {
            return new ResultSetEntries(this);
        }

        public Object get(Object key) {
            if (!this.containsKey(key)) {
                return null;
            }
            try {
                ResultSetDataModel.this.resultSet.absolute(ResultSetDataModel.this.index + 1);
                return ResultSetDataModel.this.resultSet.getObject((String)this.realKey(key));
            }
            catch (SQLException e) {
                throw new FacesException();
            }
        }

        public Set keySet() {
            return new ResultSetKeys(this);
        }

        public Object put(Object key, Object value) {
            if (!this.containsKey(key)) {
                throw new IllegalArgumentException();
            }
            try {
                ResultSetDataModel.this.resultSet.absolute(ResultSetDataModel.this.index + 1);
                String realKey = (String)this.realKey(key);
                ResultSetDataModel.this.resultSet.updateObject(realKey, value);
                ResultSetDataModel.this.isUpdated = true;
                return ResultSetDataModel.this.resultSet.getObject(realKey);
            }
            catch (SQLException e) {
                throw new FacesException();
            }
        }

        public Collection values() {
            return new ResultSetValues(this);
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object obj) {
            throw new UnsupportedOperationException();
        }

        public Object realKey(Object key) {
            return super.get(key);
        }

        public Iterator realKeys() {
            return super.keySet().iterator();
        }

        private ResultSetMetaData getMetaData() {
            try {
                if (this.metaData == null) {
                    this.metaData = ResultSetDataModel.this.resultSet.getMetaData();
                }
            }
            catch (SQLException e) {
                throw new FacesException();
            }
            return this.metaData;
        }
    }
}

