/*
 * Copyright 2004-2011 the Seasar Foundation and the Others.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.seasar.teeda.extension.jsp;

import org.seasar.framework.mock.servlet.MockHttpServletResponse;
import org.seasar.framework.unit.S2FrameworkTestCase;

/**
 * @author higa
 *
 */
public class JspWriterImplTest extends S2FrameworkTestCase {

    public void testWrite() throws Exception {
        final MockHttpServletResponse res = getResponse();
        final JspWriterImpl writer = new JspWriterImpl(res, 2, true);
        final String s = "abcde";
        char[] cb = s.toCharArray();
        writer.write(cb);
        writer.flush();
        assertEquals("1", s, new String(res.getResponseBytes()));
    }

}