/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.unit.xmlunit;

import java.util.ArrayList;
import java.util.List;
import org.custommonkey.xmlunit.Difference;
import org.custommonkey.xmlunit.DifferenceConstants;
import org.custommonkey.xmlunit.DifferenceListener;
import org.custommonkey.xmlunit.NodeDetail;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TextTrimmingDifferenceListener
implements DifferenceListener {
    public int differenceFound(Difference difference) {
        NodeDetail cNodeDetail = difference.getControlNodeDetail();
        NodeDetail tNodeDetail = difference.getTestNodeDetail();
        Node cNode = cNodeDetail.getNode();
        Node tNode = tNodeDetail.getNode();
        if (DifferenceConstants.TEXT_VALUE.getId() == difference.getId()) {
            String cNodeDetailValue = cNodeDetail.getValue();
            String tNodeDetailValue = tNodeDetail.getValue();
            if (cNodeDetailValue.trim().equals(tNodeDetailValue.trim())) {
                System.out.println("recover:TEXT_VALUE");
                return 1;
            }
        } else if (DifferenceConstants.NODE_TYPE.getId() == difference.getId()) {
            String cNodeValue = cNode.getNodeValue();
            String tNodeValue = tNode.getNodeValue();
            if (this.isBlank(cNodeValue) && this.isBlank(tNodeValue)) {
                System.out.println("recover:NODE_TYPE");
                return 1;
            }
        } else if (DifferenceConstants.HAS_CHILD_NODES.getId() == difference.getId()) {
            NodeList cChildNodes = cNode.getChildNodes();
            NodeList tChildNodes = tNode.getChildNodes();
            NodeList containChildrenNode = cChildNodes.getLength() == 0 ? tChildNodes : cChildNodes;
            List nodes = this.minusEmptyTextNode(containChildrenNode);
            if (nodes.isEmpty()) {
                System.out.println("recover:HAS_CHILD_NODES");
                return 1;
            }
            if (3 == cNode.getNodeType() || 3 == tNode.getNodeType()) {
                System.out.println("recover:HAS_CHILD_NODES (one is TEXT_NODE)");
                return 1;
            }
        } else if (DifferenceConstants.CHILD_NODELIST_LENGTH.getId() == difference.getId()) {
            NodeList cChildNodes = cNode.getChildNodes();
            NodeList tChildNodes = tNode.getChildNodes();
            List cNodeList = this.minusEmptyTextNode(cChildNodes);
            List tNodeList = this.minusEmptyTextNode(tChildNodes);
            if (cNodeList.size() == tNodeList.size()) {
                boolean equal = true;
                for (int i = 0; i < cNodeList.size(); ++i) {
                    String node2Value;
                    String node1Value;
                    Node node1 = (Node)cNodeList.get(i);
                    Node node2 = (Node)tNodeList.get(i);
                    if (node1.getNodeType() != node2.getNodeType()) {
                        equal = false;
                    }
                    if (!node1.getNodeName().equals(node2.getNodeName())) {
                        equal = false;
                    }
                    if (this.equals(node1Value = node1.getNodeValue(), node2Value = node2.getNodeValue())) continue;
                    equal = false;
                }
                if (equal) {
                    System.out.println("recover:CHILD_NODELIST_LENGTH");
                    return 1;
                }
            }
        } else if (DifferenceConstants.CHILD_NODELIST_SEQUENCE.getId() == difference.getId()) {
            System.out.println("recover:CHILD_NODELIST_SEQUENCE");
            return 1;
        }
        return 0;
    }

    private List minusEmptyTextNode(NodeList containChildrenNode) {
        ArrayList<Node> l = new ArrayList<Node>();
        for (int i = 0; i < containChildrenNode.getLength(); ++i) {
            Node node = containChildrenNode.item(i);
            String nodeValue = node.getNodeValue();
            if (3 != node.getNodeType()) {
                l.add(node);
                continue;
            }
            if (nodeValue == null || "".equals(nodeValue.trim())) continue;
            l.add(node);
        }
        return l;
    }

    public void skippedComparison(Node node1, Node node2) {
    }

    boolean equals(String target1, String target2) {
        return target1 == null ? target2 == null : target1.equals(target2);
    }

    boolean isBlank(String str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

