/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.context.FacesContext;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.teeda.core.util.DIContainerUtil;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.PageScopeHandler;
import org.seasar.teeda.extension.html.impl.ScopeValueHelper;

public class PageScopeHandlerImpl
implements PageScopeHandler {
    private Map pageNamesMap = new HashMap();

    public boolean toPage(PageDesc pageDesc, FacesContext context) {
        if (pageDesc == null || context == null || !pageDesc.hasPageScopeProperty()) {
            return false;
        }
        boolean changed = false;
        Map pageScopeValues = ScopeValueHelper.getOrCreatePageScopeValues(context);
        String pageName = pageDesc.getPageName();
        Object page = DIContainerUtil.getComponent((Object)pageName);
        if (page == null) {
            return false;
        }
        String[] names = null;
        if (!this.pageNamesMap.containsKey(pageName)) {
            names = pageDesc.getPageScopePropertyNames();
        } else {
            List list = (List)this.pageNamesMap.get(pageName);
            names = list.toArray(new String[list.size()]);
        }
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(page.getClass());
        for (int i = 0; i < names.length; ++i) {
            String propertyName = names[i];
            if (!beanDesc.hasPropertyDesc(propertyName)) continue;
            PropertyDesc pd = beanDesc.getPropertyDesc(propertyName);
            Object pageValue = pd.isReadable() ? pd.getValue(page) : null;
            Object scopeValue = pageScopeValues.get(propertyName);
            if (pageValue != null && !pageValue.equals(scopeValue)) {
                changed = true;
                continue;
            }
            if (!pd.isWritable()) continue;
            pd.setValue(page, scopeValue);
        }
        return changed;
    }

    public boolean toScope(PageDesc pageDesc, FacesContext context) {
        if (pageDesc == null || context == null || !pageDesc.hasPageScopeProperty()) {
            return false;
        }
        Map pageScopeValues = ScopeValueHelper.getOrCreatePageScopeValues(context);
        String pageName = pageDesc.getPageName();
        Object page = DIContainerUtil.getComponent((Object)pageName);
        ArrayList<String> list = null;
        boolean cached = this.pageNamesMap.containsKey(pageName);
        if (!cached) {
            list = new ArrayList<String>();
            this.pageNamesMap.put(pageName, list);
        }
        String[] names = pageDesc.getPageScopePropertyNames();
        if (page == null) {
            return false;
        }
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(page.getClass());
        for (int i = 0; i < names.length; ++i) {
            PropertyDesc propertyDesc;
            String propertyName = names[i];
            if (!beanDesc.hasPropertyDesc(propertyName)) continue;
            if (!cached) {
                list.add(propertyName);
            }
            if (!(propertyDesc = beanDesc.getPropertyDesc(propertyName)).isReadable()) continue;
            Object value = propertyDesc.getValue(page);
            pageScopeValues.put(propertyName, value);
        }
        return true;
    }
}

