/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.factory;

import java.util.Iterator;
import java.util.Map;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.util.BindingUtil;
import org.seasar.teeda.extension.config.taglib.TaglibManager;
import org.seasar.teeda.extension.config.taglib.element.TagElement;
import org.seasar.teeda.extension.config.taglib.element.TaglibElement;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.ElementProcessor;
import org.seasar.teeda.extension.html.ElementProcessorFactory;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.processor.ElementProcessorImpl;

public abstract class AbstractElementProcessorFactory
implements ElementProcessorFactory {
    private TaglibManager taglibManager;

    public TaglibManager getTaglibManager() {
        return this.taglibManager;
    }

    public void setTaglibManager(TaglibManager taglibManager) {
        this.taglibManager = taglibManager;
    }

    public ElementProcessor createProcessor(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        String tagName;
        String uri = this.getUri();
        if (StringUtil.isEmpty((String)uri)) {
            uri = elementNode.getNamespaceURI();
        }
        if (StringUtil.isEmpty((String)(tagName = this.getTagName()))) {
            tagName = elementNode.getLocalName();
        }
        return this.createProcessor(elementNode, pageDesc, actionDesc, uri, tagName);
    }

    public boolean isLeaf() {
        return false;
    }

    protected Class getTagClass(String uri, String tagName) {
        TaglibElement taglibElement = this.taglibManager.getTaglibElement(uri);
        TagElement tagElement = taglibElement.getTagElement(tagName);
        return tagElement.getTagClass();
    }

    protected boolean hasTaglibElement(String uri) {
        return this.taglibManager.hasTaglibElement(uri);
    }

    protected ElementProcessor createProcessor(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc, String uri, String tagName) {
        Class tagClass = this.getTagClass(uri, tagName);
        Map props = this.createProperties(elementNode, pageDesc, actionDesc);
        ElementProcessorImpl processor = new ElementProcessorImpl(tagClass, props);
        this.customizeProcessor(processor, elementNode, pageDesc, actionDesc);
        return processor;
    }

    protected void customizeProcessor(ElementProcessor processor, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
    }

    protected Map createProperties(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        Map props = elementNode.copyProperties();
        this.customizeProperties(props, elementNode, pageDesc, actionDesc);
        return props;
    }

    protected void customizeProperties(Map properties, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        this.renameProperty(properties, "class", "styleClass");
        this.customizeDynamicProperties(properties, elementNode, pageDesc, actionDesc);
    }

    protected void customizeDynamicProperties(Map properties, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        String s = elementNode.getProperty("id");
        if (s == null) {
            return;
        }
        int pos = s.indexOf(45);
        String id = -1 < pos ? s.substring(0, pos) + StringUtil.capitalize((String)s.substring(pos + 1)) : s;
        this.customizeDynamicProperties(id, properties, elementNode, pageDesc, actionDesc);
    }

    protected void customizeDynamicProperties(String base, Map properties, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        if (base == null) {
            return;
        }
        Iterator i = properties.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            if ("id".equals(key)) continue;
            this.customizeDynamicProperty(base, key, properties, elementNode, pageDesc, actionDesc);
        }
    }

    protected void customizeDynamicProperty(String base, String name, Map properties, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        String s;
        if (pageDesc == null) {
            this.customizeLabelProperty(name, properties, pageDesc);
            return;
        }
        String pageName = pageDesc.getPageName();
        if (name.equals("styleClass") && !StringUtil.isEmpty((String)base) && pageDesc.hasDynamicProperty(s = base + StringUtil.capitalize((String)"class"))) {
            properties.put(name, this.getBindingExpression(pageName, s));
            return;
        }
        String propName = base + StringUtil.capitalize((String)name);
        if (pageDesc.hasDynamicProperty(propName)) {
            properties.put(name, this.getBindingExpression(pageName, propName));
            return;
        }
        this.customizeLabelProperty(name, properties, pageDesc);
    }

    protected void customizeDynamicPropertyIfNotExists(String base, String name, Map properties, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        if (!properties.containsKey(name)) {
            this.customizeDynamicProperty(base, name, properties, elementNode, pageDesc, actionDesc);
        }
    }

    protected void customizeLabelProperty(String name, Map properties, PageDesc pageDesc) {
        String value = (String)properties.get(name);
        if (pageDesc == null || value == null || !value.endsWith("Label")) {
            return;
        }
        properties.put(name, this.getLabelExpression(value, pageDesc));
    }

    protected void renameProperty(Map properties, String from, String to) {
        if (properties.containsKey(from)) {
            Object value = properties.remove(from);
            properties.put(to, value);
        }
    }

    protected String getBindingExpression(String componentName, String targetName) {
        return BindingUtil.getExpression((String)componentName, (String)targetName);
    }

    protected String getLabelExpression(String attributeValue, PageDesc pageDesc) {
        String pageName = pageDesc.getPageName();
        String labelName = attributeValue.substring(0, attributeValue.length() - "Label".length());
        return "#{labelProvider." + pageName + "." + labelName + "}";
    }

    protected abstract String getUri();

    protected abstract String getTagName();
}

