/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.HtmlNode;
import org.seasar.teeda.extension.html.TextNode;
import org.seasar.teeda.extension.html.impl.HtmlNodeUtil;
import org.seasar.teeda.extension.html.impl.TextNodeImpl;

public class ElementNodeImpl
implements ElementNode {
    private String namespaceURI;
    private String localName;
    private String tagName;
    private ElementNode parent;
    private Map properties;
    private List children = new ArrayList();
    private StringBuffer buffer;
    private int childTextSize;
    private String normalizedId;

    public ElementNodeImpl(String namespaceURI, String localName, String tagName, Map properties) {
        this.namespaceURI = namespaceURI;
        this.localName = localName;
        this.tagName = tagName;
        this.properties = properties;
        this.initializeBuffer();
        this.normalizedId = this.normalizeId();
    }

    protected String normalizeId() {
        String id = this.getId();
        if (StringUtil.isEmpty((String)id)) {
            return null;
        }
        int indexOf = id.indexOf("-");
        if (indexOf <= 0) {
            return null;
        }
        return id.substring(0, indexOf);
    }

    protected void initializeBuffer() {
        this.buffer = new StringBuffer(512);
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getId() {
        if (this.normalizedId != null) {
            return this.normalizedId;
        }
        return this.getProperty("id");
    }

    public String getProperty(String name) {
        return (String)this.properties.get(name);
    }

    public Iterator getPropertyNameIterator() {
        return this.properties.keySet().iterator();
    }

    public Map copyProperties() {
        return new HashMap(this.properties);
    }

    public void addText(String text) {
        this.buffer.append(text);
    }

    public void addElement(ElementNode elementNode) {
        this.processText();
        this.renewParent(elementNode);
        this.addChild(elementNode);
    }

    private void renewParent(ElementNode elementNode) {
        ElementNode oldParent = elementNode.getParent();
        if (oldParent != null) {
            oldParent.removeChild(elementNode);
        }
        elementNode.setParent(this);
    }

    protected void processText() {
        if (this.buffer.length() > 0) {
            this.addChild(new TextNodeImpl(this.buffer.toString()));
            this.initializeBuffer();
        }
    }

    public void endElement() {
        this.processText();
    }

    public int getChildSize() {
        return this.children.size();
    }

    public HtmlNode getChild(int index) {
        return (HtmlNode)this.children.get(index);
    }

    protected void addChild(HtmlNode child) {
        this.children.add(child);
    }

    public int getChildTextSize() {
        return this.childTextSize;
    }

    public void incrementChildTextSize() {
        ++this.childTextSize;
    }

    public void decrementChildTextSize() {
        --this.childTextSize;
    }

    public String getCompleteTagString() {
        return HtmlNodeUtil.getCompleteTagString(this.tagName, this.properties);
    }

    public String getStartTagString() {
        return HtmlNodeUtil.getStartTagString(this.tagName, this.properties);
    }

    public String getEndTagString() {
        return HtmlNodeUtil.getEndTagString(this.tagName);
    }

    public String toString() {
        if (this.getChildSize() == 0) {
            return this.getCompleteTagString();
        }
        StringBuffer buf = new StringBuffer(512);
        buf.append(this.getStartTagString());
        for (int i = 0; i < this.getChildSize(); ++i) {
            buf.append(this.getChild(i).toString());
        }
        buf.append(this.getEndTagString());
        return buf.toString();
    }

    public ElementNode getParent() {
        return this.parent;
    }

    public void setParent(ElementNode elementNode) {
        this.parent = elementNode;
    }

    public void removeChild(HtmlNode node) {
        this.children.remove(node);
    }

    public TextNode getFirstTextNode() {
        for (int i = 0; i < this.getChildSize(); ++i) {
            HtmlNode child = this.getChild(i);
            if (!(child instanceof TextNode)) continue;
            return (TextNode)child;
        }
        return null;
    }
}

