/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.factory;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.ElementProcessor;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.factory.AbstractElementProcessorFactory;
import org.seasar.teeda.extension.html.processor.ForEachElementProcessor;

public class ForEachFactory
extends AbstractElementProcessorFactory {
    private static final Set acceptableElements = new HashSet();
    private static final String TAG_NAME = "forEach";

    public boolean isMatch(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        if (elementNode == null || pageDesc == null) {
            return false;
        }
        String elementName = elementNode.getTagName();
        if (!acceptableElements.contains(elementName.toLowerCase())) {
            return false;
        }
        String id = elementNode.getId();
        if (id == null) {
            return false;
        }
        return id.endsWith("Items") && pageDesc.hasItemsProperty(id);
    }

    protected void customizeProperties(Map properties, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        super.customizeProperties(properties, elementNode, pageDesc, actionDesc);
        if (pageDesc == null) {
            return;
        }
        String id = elementNode.getId();
        properties.put("pageName", pageDesc.getPageName());
        properties.put("itemsName", id);
    }

    protected String getTagName() {
        return TAG_NAME;
    }

    protected String getUri() {
        return "http://www.seasar.org/teeda/extension";
    }

    protected ElementProcessor createProcessor(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc, String uri, String tagName) {
        Class tagClass = this.getTagClass(uri, tagName);
        Map props = this.createProperties(elementNode, pageDesc, actionDesc);
        ForEachElementProcessor processor = new ForEachElementProcessor(tagClass, props, elementNode.getTagName());
        this.customizeProcessor(processor, elementNode, pageDesc, actionDesc);
        return processor;
    }

    static {
        acceptableElements.add("div");
        acceptableElements.add("span");
        acceptableElements.add("table");
        acceptableElements.add("tbody");
        acceptableElements.add("tr");
        acceptableElements.add("ul");
        acceptableElements.add("ol");
        acceptableElements.add("dl");
    }
}

