/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.application;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.NavigationHandler;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.BigDecimalConverter;
import javax.faces.convert.BigIntegerConverter;
import javax.faces.convert.BooleanConverter;
import javax.faces.convert.ByteConverter;
import javax.faces.convert.CharacterConverter;
import javax.faces.convert.Converter;
import javax.faces.convert.DateTimeConverter;
import javax.faces.convert.DoubleConverter;
import javax.faces.convert.FloatConverter;
import javax.faces.convert.IntegerConverter;
import javax.faces.convert.LongConverter;
import javax.faces.convert.ShortConverter;
import javax.faces.el.MethodBinding;
import javax.faces.el.PropertyResolver;
import javax.faces.el.ReferenceSyntaxException;
import javax.faces.el.ValueBinding;
import javax.faces.el.VariableResolver;
import javax.faces.event.ActionListener;
import javax.faces.validator.Validator;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.DateConversionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.application.ComponentLookupStrategy;
import org.seasar.teeda.core.application.ConfigurationSupport;
import org.seasar.teeda.core.application.ConverterConfiguration;
import org.seasar.teeda.core.application.impl.DefaultComponentLookupStrategy;
import org.seasar.teeda.core.convert.TimestampConverter;
import org.seasar.teeda.core.el.MethodBindingFactory;
import org.seasar.teeda.core.el.ValueBindingFactory;
import org.seasar.teeda.core.exception.ConverterInstantiateFailureException;
import org.seasar.teeda.core.exception.NoMethodBindingContextException;
import org.seasar.teeda.core.exception.NoValueBindingContextException;
import org.seasar.teeda.core.util.ApplicationUtil;
import org.seasar.teeda.core.util.IteratorUtil;
import org.seasar.teeda.core.util.PropertyDescUtil;

public class ApplicationImpl
extends Application
implements ConfigurationSupport {
    private static Map wellKnownConverters = new HashMap();
    private ActionListener listener = null;
    private Locale locale = null;
    private String renderKitId = null;
    private String bundle = null;
    private NavigationHandler navigationHandler = null;
    private PropertyResolver propertyResolver = null;
    private VariableResolver variableResolver = null;
    private ViewHandler viewHandler = null;
    private StateManager stateManager = null;
    private Map componentClassMap = Collections.synchronizedMap(new HashMap());
    private Map converterIdMap = Collections.synchronizedMap(new HashMap());
    private Map converterForClassMap = Collections.synchronizedMap(new HashMap());
    private Map converterConfigurationMap = Collections.synchronizedMap(new HashMap());
    private Map validatorMap = Collections.synchronizedMap(new HashMap());
    private Collection supportedLocales = Collections.EMPTY_SET;
    private ValueBindingFactory vbFactory = null;
    private MethodBindingFactory mbFactory = null;
    private ComponentLookupStrategy componentLookupStrategy = new DefaultComponentLookupStrategy();

    public static Converter getWellKnownConverter(Class clazz) {
        return (Converter)wellKnownConverters.get(clazz);
    }

    protected static void registerWellKnownConverters() {
        Converter converter = new BooleanConverter();
        wellKnownConverters.put(Boolean.class, converter);
        wellKnownConverters.put(Boolean.TYPE, converter);
        converter = new ByteConverter();
        wellKnownConverters.put(Byte.class, converter);
        wellKnownConverters.put(Byte.TYPE, converter);
        converter = new ShortConverter();
        wellKnownConverters.put(Short.class, converter);
        wellKnownConverters.put(Short.TYPE, converter);
        converter = new IntegerConverter();
        wellKnownConverters.put(Integer.class, converter);
        wellKnownConverters.put(Integer.TYPE, converter);
        converter = new LongConverter();
        wellKnownConverters.put(Long.class, converter);
        wellKnownConverters.put(Long.TYPE, converter);
        converter = new FloatConverter();
        wellKnownConverters.put(Float.class, converter);
        wellKnownConverters.put(Float.TYPE, converter);
        converter = new DoubleConverter();
        wellKnownConverters.put(Double.class, converter);
        wellKnownConverters.put(Double.TYPE, converter);
        converter = new BigIntegerConverter();
        wellKnownConverters.put(BigInteger.class, converter);
        converter = new BigDecimalConverter();
        wellKnownConverters.put(BigDecimal.class, converter);
        converter = new CharacterConverter();
        wellKnownConverters.put(Character.class, converter);
        wellKnownConverters.put(Character.TYPE, converter);
        DateTimeConverter dateTimeConverter = new DateTimeConverter();
        dateTimeConverter.setPattern(DateConversionUtil.getY4Pattern((Locale)Locale.getDefault()));
        wellKnownConverters.put(Date.class, dateTimeConverter);
        TimestampConverter timestampConverter = new TimestampConverter();
        timestampConverter.setPattern(DateConversionUtil.getY4Pattern((Locale)Locale.getDefault()));
        wellKnownConverters.put(Timestamp.class, timestampConverter);
    }

    public ActionListener getActionListener() {
        return this.listener;
    }

    public void setActionListener(ActionListener listener) {
        AssertionUtil.assertNotNull((String)"ActionListener is null.", (Object)listener);
        this.listener = listener;
    }

    public Locale getDefaultLocale() {
        return this.locale;
    }

    public void setDefaultLocale(Locale locale) {
        AssertionUtil.assertNotNull((String)"Locale is null.", (Object)locale);
        this.locale = locale;
    }

    public String getDefaultRenderKitId() {
        return this.renderKitId;
    }

    public void setDefaultRenderKitId(String renderKitId) {
        this.renderKitId = renderKitId;
    }

    public String getMessageBundle() {
        return this.bundle;
    }

    public void setMessageBundle(String bundle) {
        AssertionUtil.assertNotNull((String)"MessageBundle is null.", (Object)bundle);
        this.bundle = bundle;
    }

    public NavigationHandler getNavigationHandler() {
        return this.navigationHandler;
    }

    public void setNavigationHandler(NavigationHandler handler) {
        AssertionUtil.assertNotNull((String)"NavigationHandler is null.", (Object)handler);
        this.navigationHandler = handler;
    }

    public PropertyResolver getPropertyResolver() {
        return this.propertyResolver;
    }

    public void setPropertyResolver(PropertyResolver resolver) {
        AssertionUtil.assertNotNull((String)"PropertyResolver is null.", (Object)resolver);
        this.propertyResolver = resolver;
    }

    public VariableResolver getVariableResolver() {
        return this.variableResolver;
    }

    public void setVariableResolver(VariableResolver resolver) {
        AssertionUtil.assertNotNull((String)"VariableResolver is null.", (Object)resolver);
        this.variableResolver = resolver;
    }

    public ViewHandler getViewHandler() {
        return this.viewHandler;
    }

    public void setViewHandler(ViewHandler handler) {
        AssertionUtil.assertNotNull((String)"ViewHandler is null.", (Object)handler);
        this.viewHandler = handler;
    }

    public StateManager getStateManager() {
        return this.stateManager;
    }

    public void setStateManager(StateManager manager) {
        AssertionUtil.assertNotNull((String)"StateManager is null.", (Object)manager);
        this.stateManager = manager;
    }

    public void addComponent(String componentType, String componentClassName) {
        if (StringUtil.isEmpty((String)componentType)) {
            throw new NullPointerException("componentType is null.");
        }
        if (StringUtil.isEmpty((String)componentClassName)) {
            throw new NullPointerException("componentClassName is null.");
        }
        Class clazz = ClassUtil.forName((String)componentClassName);
        ApplicationUtil.verifyClassType(UIComponent.class, clazz);
        this.componentClassMap.put(componentType, clazz);
    }

    public UIComponent createComponent(String componentType) throws FacesException {
        if (StringUtil.isEmpty((String)componentType)) {
            throw new NullPointerException("componentType is null.");
        }
        Object component = this.componentLookupStrategy.getComponentByName(componentType);
        if (component != null) {
            return (UIComponent)component;
        }
        Class componentClass = (Class)this.componentClassMap.get(componentType);
        if (componentClass == null) {
            throw new FacesException("Undefined component type:" + componentType);
        }
        return (UIComponent)ClassUtil.newInstance((Class)componentClass);
    }

    public UIComponent createComponent(ValueBinding vb, FacesContext context, String componentType) throws FacesException {
        Object obj = vb.getValue(context);
        if (obj instanceof UIComponent) {
            return (UIComponent)obj;
        }
        UIComponent component = this.createComponent(componentType);
        vb.setValue(context, component);
        return component;
    }

    public Iterator getComponentTypes() {
        return this.componentClassMap.keySet().iterator();
    }

    public void addConverter(String converterId, String converterClassName) {
        if (StringUtil.isEmpty((String)converterId)) {
            throw new NullPointerException("converterId is null");
        }
        if (StringUtil.isEmpty((String)converterClassName)) {
            throw new NullPointerException("converterClass is null");
        }
        Class clazz = ClassUtil.forName((String)converterClassName);
        ApplicationUtil.verifyClassType(Converter.class, clazz);
        this.converterIdMap.put(converterId, clazz);
    }

    public void addConverter(Class targetClass, String converterClassName) {
        AssertionUtil.assertNotNull((String)"targetClass is null", (Object)targetClass);
        if (StringUtil.isEmpty((String)converterClassName)) {
            throw new NullPointerException("converterClass is null");
        }
        Class clazz = ClassUtil.forName((String)converterClassName);
        ApplicationUtil.verifyClassType(Converter.class, clazz);
        this.converterForClassMap.put(targetClass, clazz);
    }

    public Converter createConverter(String converterId) {
        AssertionUtil.assertNotNull((String)"converterId is null", (Object)converterId);
        Object component = this.componentLookupStrategy.getComponentByName(converterId);
        if (component != null) {
            return (Converter)component;
        }
        Class clazz = (Class)this.converterIdMap.get(converterId);
        try {
            Converter converter = this.createConverterByConverterClass(clazz);
            this.setConverterPropertiesFor(converterId, converter);
            return converter;
        }
        catch (Exception e) {
            Object[] args = new Object[]{converterId};
            throw new ConverterInstantiateFailureException(args);
        }
    }

    public Converter createConverter(Class targetClass) {
        AssertionUtil.assertNotNull((String)"targetClass is null", (Object)targetClass);
        return this.doCreateConverterByTargetClass(targetClass);
    }

    public void addConverterConfiguration(String converterId, ConverterConfiguration converterConfiguration) {
        if (StringUtil.isEmpty((String)converterId)) {
            throw new NullPointerException("converterId is null.");
        }
        AssertionUtil.assertNotNull((String)"converterConfiguration is null", (Object)converterConfiguration);
        List list = this.getConverterConfigurationList(converterId);
        list.add(converterConfiguration);
    }

    public void addConverterConfiguration(Class targetClass, ConverterConfiguration converterConfiguration) {
        AssertionUtil.assertNotNull((String)"targetClass is null", (Object)targetClass);
        AssertionUtil.assertNotNull((String)"converterConfiguration is null", (Object)converterConfiguration);
        List list = this.getConverterConfigurationList(targetClass);
        list.add(converterConfiguration);
    }

    private List getConverterConfigurationList(Object key) {
        ArrayList list = (ArrayList)this.converterConfigurationMap.get(key);
        if (list == null) {
            list = new ArrayList();
            this.converterConfigurationMap.put(key, list);
        }
        return list;
    }

    private Converter createConverterByConverterClass(Class converterClass) {
        try {
            Converter converter = (Converter)ClassUtil.newInstance((Class)converterClass);
            return converter;
        }
        catch (Exception e) {
            Object[] args = new Object[]{converterClass.getName()};
            throw new ConverterInstantiateFailureException(args);
        }
    }

    private Converter doCreateConverterByTargetClass(Class targetClass) {
        Converter converter = ApplicationImpl.getWellKnownConverter(targetClass);
        if (converter != null) {
            return converter;
        }
        converter = this.createConverterByTargetClass(targetClass);
        if (converter == null) {
            converter = this.createConverterByInterface(targetClass);
        }
        if (converter == null) {
            converter = this.createConverterBySuperClass(targetClass);
        }
        if (converter == null) {
            converter = this.createConverterForPrimitive(targetClass);
        }
        if (converter != null) {
            this.setConverterPropertiesFor(targetClass, converter);
        }
        return converter;
    }

    private void setConverterPropertiesFor(Object key, Converter converter) {
        List list = (List)this.converterConfigurationMap.get(key);
        Iterator itr = IteratorUtil.getIterator(list);
        while (itr.hasNext()) {
            ConverterConfiguration config = (ConverterConfiguration)itr.next();
            if (config == null) continue;
            String propertyName = config.getPropertyName();
            PropertyDescUtil.setValue(converter, propertyName, config.getDefaultValue());
        }
    }

    protected Converter createConverterByTargetClass(Class targetClass) {
        Class converterClass = (Class)this.converterForClassMap.get(targetClass);
        if (converterClass != null) {
            return this.createConverterByConverterClass(converterClass);
        }
        return null;
    }

    protected Converter createConverterByInterface(Class targetClass) {
        Class<?>[] interfaces = targetClass.getInterfaces();
        if (interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                Converter converter = this.doCreateConverterByTargetClass(interfaces[i]);
                if (converter == null) continue;
                return converter;
            }
        }
        return null;
    }

    protected Converter createConverterBySuperClass(Class targetClass) {
        Class superClass = targetClass.getSuperclass();
        if (superClass != null) {
            return this.doCreateConverterByTargetClass(superClass);
        }
        return null;
    }

    protected Converter createConverterForPrimitive(Class targetClass) {
        Class primitiveClass = ClassUtil.getWrapperClass((Class)targetClass);
        if (primitiveClass != null) {
            return this.doCreateConverterByTargetClass(primitiveClass);
        }
        return null;
    }

    public Iterator getConverterIds() {
        return this.converterIdMap.keySet().iterator();
    }

    public Iterator getConverterTypes() {
        return this.converterForClassMap.keySet().iterator();
    }

    public Iterator getSupportedLocales() {
        return this.supportedLocales.iterator();
    }

    public void setSupportedLocales(Collection supportedLocales) {
        AssertionUtil.assertNotNull((String)"suppoertedLocales is null", (Object)supportedLocales);
        this.supportedLocales = supportedLocales;
    }

    public void addValidator(String validatorId, String validatorClassName) {
        if (StringUtil.isEmpty((String)validatorId)) {
            throw new NullPointerException("Validator id is null.");
        }
        if (StringUtil.isEmpty((String)validatorClassName)) {
            throw new NullPointerException("Validator class is null.");
        }
        Class clazz = ClassUtil.forName((String)validatorClassName);
        ApplicationUtil.verifyClassType(Validator.class, clazz);
        this.validatorMap.put(validatorId, clazz);
    }

    public Validator createValidator(String validatorId) throws FacesException {
        AssertionUtil.assertNotNull((String)"validatorId is null", (Object)validatorId);
        Object component = this.componentLookupStrategy.getComponentByName(validatorId);
        if (component != null) {
            return (Validator)component;
        }
        Class validatorClass = (Class)this.validatorMap.get(validatorId);
        if (validatorClass == null) {
            throw new FacesException("Undefined validator class(validatorId = " + validatorId + ")");
        }
        return (Validator)ClassUtil.newInstance((Class)validatorClass);
    }

    public Iterator getValidatorIds() {
        return this.validatorMap.keySet().iterator();
    }

    public MethodBinding createMethodBinding(String ref, Class[] params) throws ReferenceSyntaxException {
        AssertionUtil.assertNotNull((String)"ref is null", (Object)ref);
        if (this.mbFactory == null) {
            throw new NoMethodBindingContextException(ref, params);
        }
        return this.mbFactory.createMethodBinding(this, ref, params);
    }

    public ValueBinding createValueBinding(String ref) throws ReferenceSyntaxException {
        AssertionUtil.assertNotNull((String)"ref is null", (Object)ref);
        if (this.vbFactory == null) {
            throw new NoValueBindingContextException(ref);
        }
        return this.vbFactory.createValueBinding(this, ref);
    }

    public void setValueBindingFactory(ValueBindingFactory vbContextFactory) {
        this.vbFactory = vbContextFactory;
    }

    public void setMethodBindingFactory(MethodBindingFactory mbContextFactory) {
        this.mbFactory = mbContextFactory;
    }

    public ValueBindingFactory getValueBindingFactory() {
        return this.vbFactory;
    }

    public MethodBindingFactory getMethodBindingFactory() {
        return this.mbFactory;
    }

    public ComponentLookupStrategy getComponentLookupStrategy() {
        return this.componentLookupStrategy;
    }

    public void setComponentLookupStrategy(ComponentLookupStrategy componentLookupStrategy) {
        this.componentLookupStrategy = componentLookupStrategy;
    }

    static {
        ApplicationImpl.registerWellKnownConverters();
    }
}

