/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.util;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.Collection;
import org.seasar.framework.beans.PropertyDesc;

public class PagePersistenceUtil {
    public static boolean isPersistenceProperty(PropertyDesc pd) {
        if (!pd.isReadable()) {
            return false;
        }
        if (!pd.hasReadMethod() && Modifier.isTransient(pd.getField().getModifiers())) {
            return false;
        }
        return PagePersistenceUtil.isPersistenceType(pd.getPropertyType());
    }

    public static boolean isPersistenceType(Class clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        if (Serializable.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Externalizable.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (clazz.isArray()) {
            Class<?> componentType = clazz.getComponentType();
            return PagePersistenceUtil.isPersistenceType(componentType);
        }
        return Collection.class.isAssignableFrom(clazz);
    }
}

