/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.impl;

import org.seasar.framework.util.StringUtil;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public class TeedaXMLFilter
extends XMLFilterImpl
implements LexicalHandler {
    protected static final char[] BEGIN_COMMENT = "<!--".toCharArray();
    protected static final char[] END_COMMENT = "-->".toCharArray();
    protected static final char[] BEGIN_CDATA = "<![CDATA[".toCharArray();
    protected static final char[] END_CDATA = "]]>".toCharArray();
    protected static final String LINE_SEP = System.getProperty("line.separator");
    protected int depth;

    public TeedaXMLFilter(XMLReader parent) {
        super(parent);
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        StringBuffer buf = new StringBuffer(128);
        buf.append("<!DOCTYPE ").append(name);
        if (!StringUtil.isEmpty((String)publicId)) {
            buf.append(" PUBLIC \"").append(publicId).append("\"");
        }
        if (!StringUtil.isEmpty((String)systemId)) {
            if (StringUtil.isEmpty((String)publicId)) {
                buf.append(" SYSTEM");
            }
            buf.append(" \"").append(systemId).append("\"");
        }
        buf.append(">").append(LINE_SEP);
        String docTypeDecl = new String(buf);
        super.characters(docTypeDecl.toCharArray(), 0, docTypeDecl.length());
        ++this.depth;
    }

    public void endDTD() throws SAXException {
        --this.depth;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.depth == 0) {
            super.characters(ch, start, length);
        }
    }

    public void startEntity(String name) throws SAXException {
        String entityRef = new String(new StringBuffer(name.length() + 2).append('&').append(name).append(';'));
        this.characters(entityRef.toCharArray(), 0, entityRef.length());
        ++this.depth;
    }

    public void endEntity(String name) throws SAXException {
        --this.depth;
    }

    public void startCDATA() throws SAXException {
        this.characters(BEGIN_CDATA, 0, BEGIN_CDATA.length);
    }

    public void endCDATA() throws SAXException {
        this.characters(END_CDATA, 0, END_CDATA.length);
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.characters(BEGIN_COMMENT, 0, BEGIN_COMMENT.length);
        this.characters(ch, start, length);
        this.characters(END_COMMENT, 0, END_COMMENT.length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        String pi = new String(new StringBuffer(target.length() + data.length() + 5).append("<?").append(target).append(' ').append(data) + "?>");
        this.characters(pi.toCharArray(), 0, pi.length());
    }
}

