/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.factory;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.seasar.framework.container.S2Container;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.TextNode;
import org.seasar.teeda.extension.html.factory.AbstractElementProcessorFactory;
import org.seasar.teeda.extension.util.TeedaExtensionConfiguration;

public class OutputTextFactory
extends AbstractElementProcessorFactory {
    private static final String TAG_NAME = "outputText";
    private static final Set acceptableElements = new HashSet();
    private S2Container container;

    public boolean isMatch(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        String tagName = elementNode.getTagName();
        if (TeedaExtensionConfiguration.getInstance().outputTextSpanOnly && !tagName.equals("span")) {
            return false;
        }
        if (!acceptableElements.contains(tagName.toLowerCase())) {
            return false;
        }
        if (pageDesc == null) {
            return false;
        }
        String id = elementNode.getId();
        if (id == null) {
            return false;
        }
        if (this.isLabel(id, elementNode)) {
            return true;
        }
        return pageDesc.hasProperty(id);
    }

    public boolean isLeaf() {
        return true;
    }

    protected void customizeProperties(Map properties, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        super.customizeProperties(properties, elementNode, pageDesc, actionDesc);
        properties.put("tagName", elementNode.getTagName());
        if (pageDesc == null) {
            return;
        }
        String id = elementNode.getId();
        if (pageDesc.hasProperty(id)) {
            properties.put("value", this.getBindingExpression(pageDesc.getPageName(), id));
        } else {
            String key = this.toNormalizeId(id);
            TextNode firstTextNode = elementNode.getFirstTextNode();
            properties.put("value", this.getLabelExpression(key, pageDesc));
        }
    }

    protected boolean isLabel(String id, ElementNode elementNode) {
        String key = this.toNormalizeId(id);
        if (!TeedaExtensionConfiguration.getInstance().outputTextLabelUnderAnchorOnly) {
            return key.endsWith("Label");
        }
        ElementNode parent = elementNode.getParent();
        if (parent == null) {
            return false;
        }
        String tagName = parent.getTagName();
        return key.endsWith("Label") && tagName.equalsIgnoreCase("a");
    }

    protected String toNormalizeId(String id) {
        int pos = id.lastIndexOf(45);
        if (pos >= 0) {
            return id.substring(0, pos);
        }
        return id;
    }

    public void setContainer(S2Container container) {
        this.container = container.getRoot();
    }

    protected String getTagName() {
        return TAG_NAME;
    }

    protected String getUri() {
        return "http://www.seasar.org/teeda/extension";
    }

    static {
        acceptableElements.add("span");
        acceptableElements.add("div");
        acceptableElements.add("caption");
    }
}

