/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.seasar.teeda.extension.util.UploadedFile;

public class UploadedFileImpl
implements UploadedFile {
    private static final long serialVersionUID = 1L;
    protected final FileItem fileItem;

    public UploadedFileImpl(FileItem fileItem) {
        this.fileItem = fileItem;
    }

    public String getName() {
        String name = this.fileItem.getName();
        File file = new File(name.replace('\\', '/'));
        return file.getName();
    }

    public String getOriginalName() {
        return this.fileItem.getName();
    }

    public String getContentType() {
        return this.fileItem.getContentType();
    }

    public long getSize() {
        return this.fileItem.getSize();
    }

    public boolean isInMemory() {
        return this.fileItem.isInMemory();
    }

    public byte[] get() {
        return this.fileItem.get();
    }

    public String getString() {
        return this.fileItem.getString();
    }

    public String getString(String encoding) throws UnsupportedEncodingException {
        return this.fileItem.getString(encoding);
    }

    public InputStream getInputStream() throws IOException {
        return this.fileItem.getInputStream();
    }

    public void write(File file) throws Exception {
        this.fileItem.write(file);
    }

    public File getStoreLocation() {
        if (this.fileItem.isInMemory()) {
            return null;
        }
        return ((DiskFileItem)this.fileItem).getStoreLocation();
    }

    public void delete() {
        this.fileItem.delete();
    }
}

