/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.component;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.seasar.teeda.extension.component.TreeNode;

public class TreeNodeImpl
implements TreeNode,
Comparable,
Serializable {
    private static final long serialVersionUID = 1L;
    private List children = new LinkedList();
    private String type;
    private Object description;
    private boolean leaf;
    private Object value;
    private boolean expanded;

    public TreeNodeImpl() {
    }

    public TreeNodeImpl(String type, Object description, boolean leaf) {
        this(type, description, null, leaf);
    }

    public TreeNodeImpl(String type, Object description, Object value, boolean leaf) {
        this.type = type;
        this.description = description;
        this.value = value;
        this.leaf = leaf;
    }

    public boolean isLeaf() {
        return this.leaf || !this.hasChild();
    }

    public void setLeaf(boolean leaf) {
        this.leaf = leaf;
    }

    public List getChildren() {
        return this.children;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setDescription(Object description) {
        this.description = description;
    }

    public Object getDescription() {
        return this.description;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public int getChildCount() {
        return this.getChildren().size();
    }

    protected boolean hasChild() {
        return this.getChildCount() != 0;
    }

    public int compareTo(Object obj) {
        TreeNode otherNode = (TreeNode)obj;
        if (this.isLeaf() && !otherNode.isLeaf()) {
            return 1;
        }
        if (!this.isLeaf() && otherNode.isLeaf()) {
            return -1;
        }
        String mine = this.getDescription().toString();
        String other = otherNode.getDescription().toString();
        return mine.compareTo(other);
    }

    public void addChild(TreeNode node) {
        this.children.add(node);
    }

    public TreeNode getChild(int index) {
        return (TreeNode)this.children.get(index);
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public void setChildren(List children) {
        this.children = children;
    }
}

