/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dxo.converter.impl;

import java.math.BigDecimal;
import org.seasar.extension.dxo.converter.ConversionContext;
import org.seasar.extension.dxo.converter.impl.AbstractConverter;

public class BooleanConverter
extends AbstractConverter {
    protected static final String[] TRUES = new String[]{"yes", "y", "true", "on", "1"};
    protected static final BigDecimal ZERO = new BigDecimal("0");

    public Class[] getSourceClasses() {
        return new Class[]{Object.class};
    }

    public Class getDestClass() {
        return Boolean.class;
    }

    public Object convert(Object source, Class destClass, ConversionContext context) {
        if (source == null) {
            return null;
        }
        if (source instanceof Boolean) {
            return source;
        }
        if (source instanceof Number) {
            return this.toBoolean((Number)source);
        }
        return this.toBoolean(source.toString());
    }

    protected Object toBoolean(String value) {
        for (int i = 0; i < TRUES.length; ++i) {
            if (!TRUES[i].equalsIgnoreCase(value)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected Object toBoolean(Number value) {
        BigDecimal decimal = new BigDecimal(value.toString());
        if (decimal.compareTo(ZERO) > 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

