/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.scope.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.seasar.teeda.core.scope.Scope;
import org.seasar.teeda.core.scope.ScopeAlreadyRegisteredException;
import org.seasar.teeda.core.scope.ScopeManager;
import org.seasar.teeda.core.scope.ScopeTranslator;

public class ScopeManagerImpl
implements ScopeManager {
    private ScopeTranslator translator_;
    private static final Map SCOPES = new HashMap();
    private static final Map DEFAULT_SCOPES;

    public Scope getScope(String scopeKey) {
        if (scopeKey == null) {
            throw new IllegalArgumentException();
        }
        return (Scope)SCOPES.get(scopeKey);
    }

    public void addScope(Scope scope, Object outerComponentScope) throws ScopeAlreadyRegisteredException {
        String scopeKey = scope.getScopeKey();
        if (SCOPES.containsKey(scopeKey)) {
            throw new ScopeAlreadyRegisteredException(new Object[]{scopeKey});
        }
        SCOPES.put(scopeKey, scope);
        if (this.translator_ != null) {
            this.translator_.addScope(scope, outerComponentScope);
        }
    }

    public boolean isDefaultScope(Scope scope) {
        return DEFAULT_SCOPES.containsValue(scope);
    }

    public void setScopeTranslator(ScopeTranslator translator) {
        this.translator_ = translator;
    }

    public ScopeTranslator getScopeTranslator() {
        return this.translator_;
    }

    static {
        SCOPES.put(Scope.APPLICATION.getScopeKey(), Scope.APPLICATION);
        SCOPES.put(Scope.SESSION.getScopeKey(), Scope.SESSION);
        SCOPES.put(Scope.REQUEST.getScopeKey(), Scope.REQUEST);
        SCOPES.put(Scope.NONE.getScopeKey(), Scope.NONE);
        HashMap<String, Scope> map = new HashMap<String, Scope>();
        map.put(Scope.APPLICATION.getScopeKey(), Scope.APPLICATION);
        map.put(Scope.SESSION.getScopeKey(), Scope.SESSION);
        map.put(Scope.REQUEST.getScopeKey(), Scope.REQUEST);
        map.put(Scope.NONE.getScopeKey(), Scope.NONE);
        DEFAULT_SCOPES = Collections.unmodifiableMap(map);
    }
}

