/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.unit;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.manipulation.Sortable;
import org.junit.runner.manipulation.Sorter;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.Parameterized;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;
import org.seasar.framework.env.Env;
import org.seasar.framework.unit.FilterCompatibility;
import org.seasar.framework.unit.S2Parameterized;
import org.seasar.framework.unit.S2TestClassMethodsRunner;
import org.seasar.framework.unit.S2TestClassRunner;
import org.seasar.framework.unit.SorterCompatibility;
import org.seasar.framework.util.ResourceUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Seasar2
extends Runner
implements Filterable,
Sortable {
    public static final String S2JUNIT4_CONFIG_KEY = "org.seasar.framework.unit.s2junit4.config";
    public static final String S2JUNIT4_CONFIG_PATH = "s2junit4config.dicon";
    public static final String ENV_PATH = "env_ut.txt";
    public static final String ENV_VALUE = "ut";
    protected static S2Container configurationContainer;
    protected static Provider provider;
    private final Runner delegate;

    public Seasar2(Class<?> clazz) throws Exception {
        this.delegate = this.createTestClassRunner(clazz);
    }

    protected Runner createTestClassRunner(Class<?> clazz) throws Exception {
        return Seasar2.getProvider().createTestClassRunner(clazz);
    }

    protected static Provider getProvider() {
        return provider;
    }

    protected static void setProvider(Provider p) {
        provider = p;
    }

    public static void configure() {
        String configFile = System.getProperty(S2JUNIT4_CONFIG_KEY, S2JUNIT4_CONFIG_PATH);
        Seasar2.configure(configFile);
    }

    public static void configure(String configFile) {
        Env.setFilePath((String)ENV_PATH);
        Env.setValueIfAbsent((String)ENV_VALUE);
        if (provider == null) {
            provider = new DefaultProvider();
        }
        if (ResourceUtil.isExist((String)configFile)) {
            configurationContainer = S2ContainerFactory.create((String)configFile);
            Configurator configurator = configurationContainer.hasComponentDef(Configurator.class) ? (Configurator)configurationContainer.getComponent(Configurator.class) : new DefaultConfigurator();
            configurator.configure(configurationContainer);
        }
    }

    public static void dispose() {
        S2TestClassMethodsRunner.dispose();
        provider = null;
        if (configurationContainer != null) {
            configurationContainer.destroy();
        }
        configurationContainer = null;
        Env.initialize();
    }

    public Description getDescription() {
        return this.delegate.getDescription();
    }

    public void run(RunNotifier notifier) {
        this.delegate.run(notifier);
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        FilterCompatibility.apply(filter, this.delegate);
    }

    public void sort(Sorter sorter) {
        SorterCompatibility.apply(sorter, this.delegate);
    }

    static {
        Seasar2.configure();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultProvider
    implements Provider {
        @Override
        public Runner createTestClassRunner(Class<?> clazz) throws Exception {
            if (this.hasParameterAnnotation(clazz)) {
                return new S2Parameterized(clazz);
            }
            return new S2TestClassRunner(clazz, new S2TestClassMethodsRunner(clazz));
        }

        protected boolean hasParameterAnnotation(Class<?> clazz) {
            for (Method each : clazz.getMethods()) {
                Annotation[] annotations;
                if (each.isBridge() || each.isSynthetic() || !Modifier.isStatic(each.getModifiers())) continue;
                for (Annotation annotation : annotations = each.getAnnotations()) {
                    if (annotation.annotationType() != Parameterized.Parameters.class) continue;
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Provider {
        public Runner createTestClassRunner(Class<?> var1) throws Exception;
    }

    public static class DefaultConfigurator
    implements Configurator {
        public void configure(S2Container configurationContainer) {
            if (configurationContainer.hasComponentDef(Provider.class)) {
                provider = (Provider)configurationContainer.getComponent(Provider.class);
            }
            if (configurationContainer.hasComponentDef(S2TestClassMethodsRunner.Provider.class)) {
                S2TestClassMethodsRunner.setProvider((S2TestClassMethodsRunner.Provider)configurationContainer.getComponent(S2TestClassMethodsRunner.Provider.class));
            }
        }
    }

    public static interface Configurator {
        public void configure(S2Container var1);
    }
}

