/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.container.deployer;

import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.CyclicReferenceRuntimeException;
import org.seasar.framework.container.deployer.AbstractComponentDeployer;

public class SingletonComponentDeployer
extends AbstractComponentDeployer {
    private Object component;
    private boolean instantiating = false;

    public SingletonComponentDeployer(ComponentDef componentDef) {
        super(componentDef);
    }

    public Object deploy() {
        if (this.component == null) {
            this.assemble();
        }
        return this.component;
    }

    public void injectDependency(Object component) {
        throw new UnsupportedOperationException("injectDependency");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assemble() {
        if (this.instantiating) {
            throw new CyclicReferenceRuntimeException(this.getComponentDef().getComponentClass());
        }
        this.instantiating = true;
        try {
            this.component = this.getConstructorAssembler().assemble();
        }
        finally {
            this.instantiating = false;
        }
        this.getPropertyAssembler().assemble(this.component);
        this.getInitMethodAssembler().assemble(this.component);
    }

    public void init() {
        this.deploy();
    }

    public void destroy() {
        if (this.component == null) {
            return;
        }
        this.getDestroyMethodAssembler().assemble(this.component);
        this.component = null;
    }
}

