/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.filter;

import java.io.File;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.ArrayUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.util.ExternalMessageUtil;

public class MultipartFormDataRequestWrapper
extends HttpServletRequestWrapper {
    public static final String WWW_FORM_URLENCODED_TYPE = "application/x-www-form-urlencoded";
    private static final Logger logger = Logger.getLogger((Class)MultipartFormDataRequestWrapper.class);
    protected ServletFileUpload fileUpload;
    protected Map parameters = new HashMap(64);
    protected Map fileItems = new HashMap(64);

    public MultipartFormDataRequestWrapper(HttpServletRequest request, int maxSize, int maxFileSize, int thresholdSize, String repositoryPath) {
        super(request);
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(thresholdSize);
        if (!StringUtil.isEmpty((String)repositoryPath)) {
            factory.setRepository(new File(repositoryPath));
        }
        this.fileUpload = new ServletFileUpload((FileItemFactory)factory);
        this.fileUpload.setSizeMax((long)maxSize);
        this.fileUpload.setFileSizeMax((long)maxFileSize);
        this.parseRequest(request);
    }

    protected void parseRequest(HttpServletRequest request) {
        try {
            String encoding = request.getCharacterEncoding();
            List requestParameters = this.fileUpload.parseRequest(request);
            Iterator it = requestParameters.iterator();
            while (it.hasNext()) {
                FileItem fileItem = (FileItem)it.next();
                if (fileItem.isFormField()) {
                    String name = fileItem.getFieldName();
                    String value = fileItem.getString(encoding);
                    this.addParameter(name, value);
                    continue;
                }
                this.fileItems.put(fileItem.getFieldName(), fileItem);
            }
        }
        catch (FileUploadBase.SizeLimitExceededException e) {
            logger.log("ETDA0110", new Object[0], (Throwable)e);
            ExternalMessageUtil.addMessage((ServletRequest)request, "org.seasar.teeda.extension.component.THtmlFileUpload.SIZE_ERROR", new Object[]{new Long(e.getPermittedSize()), new Long(e.getActualSize())});
        }
        catch (FileUploadBase.FileSizeLimitExceededException e) {
            logger.log("ETDA0110", new Object[0], (Throwable)e);
            ExternalMessageUtil.addMessage((ServletRequest)request, "org.seasar.teeda.extension.component.THtmlFileUpload.FILE_SIZE_ERROR", new Object[]{new Long(e.getPermittedSize()), new Long(e.getActualSize())});
        }
        catch (Exception e) {
            logger.log("ETDA0110", new Object[0], (Throwable)e);
            ExternalMessageUtil.addMessage((ServletRequest)request, "org.seasar.teeda.extension.component.THtmlFileUpload.ERROR");
        }
        Iterator it = request.getParameterMap().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            this.addParameters(name, values);
        }
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String getParameter(String name) {
        String[] values = (String[])this.parameters.get(name);
        return values == null ? null : values[0];
    }

    public String[] getParameterValues(String name) {
        return (String[])this.parameters.get(name);
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    public Object getAttribute(String string) {
        if (string.equals("org.seasar.teeda.core.filter.MultipartFormData.itemFiles")) {
            return this.getFileItems();
        }
        return super.getAttribute(string);
    }

    public String getContentType() {
        return WWW_FORM_URLENCODED_TYPE;
    }

    public FileItem getFileItem(String fieldName) {
        return (FileItem)this.fileItems.get(fieldName);
    }

    public Map getFileItems() {
        return this.fileItems;
    }

    protected void addParameter(String name, String value) {
        if (!this.parameters.containsKey(name)) {
            this.parameters.put(name, new String[]{value});
        } else {
            Object[] oldValues = (String[])this.parameters.get(name);
            String[] newValues = (String[])ArrayUtil.add((Object[])oldValues, (Object)value);
            this.parameters.put(name, newValues);
        }
    }

    protected void addParameters(String name, String[] values) {
        if (!this.parameters.containsKey(name)) {
            this.parameters.put(name, values);
        } else {
            Object[] oldValues = (String[])this.parameters.get(name);
            String[] newValues = (String[])ArrayUtil.add((Object[])oldValues, (Object[])values);
            this.parameters.put(name, newValues);
        }
    }
}

