/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.component;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.seasar.teeda.core.scope.impl.DispatchScope;
import org.seasar.teeda.core.scope.impl.DispatchScopeFactory;
import org.seasar.teeda.extension.util.JavaScriptContext;

public class TViewRoot
extends UIViewRoot {
    public static final String DEFAULT_RENDERER_TYPE = "org.seasar.teeda.extension.ViewRoot";
    private static final String SCRIPTS_KEY = TViewRoot.class.getName() + ".SCRIPTS_KEY";
    private Map scriptsMap = new HashMap();
    private String rootViewId;

    public TViewRoot() {
        this.setRendererType(DEFAULT_RENDERER_TYPE);
    }

    public String getRootViewId() {
        return this.rootViewId;
    }

    public void setRootViewId(String rootViewId) {
        this.rootViewId = rootViewId;
    }

    public void processDecodes(FacesContext context) {
        this.decode(context);
        this.broadcastEvents(context, PhaseId.APPLY_REQUEST_VALUES);
        this.clearEventsIfResponseRendered(context);
    }

    public void addScript(String scriptId, JavaScriptContext jsContext) {
        Map scripts = this.getScriptsMap();
        if (!scripts.containsKey(scriptId)) {
            scripts.put(scriptId, jsContext);
        }
        this.scriptsMap.putAll(scripts);
    }

    public String getAllScripts() {
        StringBuffer buf = new StringBuffer(128);
        Iterator itr = this.scriptsMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            JavaScriptContext context = (JavaScriptContext)entry.getValue();
            if (!context.hasContext()) continue;
            buf.append(context.getResult());
        }
        return buf.toString();
    }

    public boolean containsScript(String scriptId) {
        return this.getScriptsMap().containsKey(scriptId);
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.scriptsMap = (Map)values[1];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.scriptsMap};
        return values;
    }

    protected Map getScriptsMap() {
        DispatchScope dispatchScope = this.getDispatchScope();
        HashMap scripts = (HashMap)dispatchScope.get((Object)SCRIPTS_KEY);
        if (scripts == null) {
            scripts = new HashMap();
            dispatchScope.put((Object)SCRIPTS_KEY, scripts);
        }
        return scripts;
    }

    protected DispatchScope getDispatchScope() {
        return DispatchScopeFactory.getDispatchScope();
    }
}

