/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.IgnoreAttribute;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.extension.component.html.THtmlLink;
import org.seasar.teeda.extension.util.PathUtil;

public class THtmlLinkRenderer
extends AbstractRenderer {
    public static final String COMPONENT_FAMILY = "org.seasar.teeda.extension.HtmlLink";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.HtmlLink";
    private static final IgnoreAttribute IGNORE_COMPONENT = THtmlLinkRenderer.buildIgnoreComponent();

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeTHtmlLinkBegin(context, (THtmlLink)component);
    }

    protected void encodeTHtmlLinkBegin(FacesContext context, THtmlLink link) throws IOException {
        String src;
        String href;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("link", (UIComponent)link);
        String rel = link.getRel();
        if (!StringUtil.isEmpty((String)rel)) {
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"rel", (Object)rel, null);
        }
        if (!StringUtil.isEmpty((String)(href = link.getHref()))) {
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"href", (Object)PathUtil.toAbsolutePath(context, href, link.getBaseViewId()), null);
        }
        if (!StringUtil.isEmpty((String)(src = link.getSrc()))) {
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"src", (Object)src, null);
        }
        this.renderRemainAttributes((UIComponent)link, writer, IGNORE_COMPONENT);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeTHtmlLinkEnd(context, (THtmlLink)component);
    }

    protected void encodeTHtmlLinkEnd(FacesContext context, THtmlLink link) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("link");
    }

    protected static IgnoreAttribute buildIgnoreComponent() {
        IgnoreAttribute ignore = new IgnoreAttribute();
        ignore.addAttributeName("rel");
        ignore.addAttributeName("href");
        ignore.addAttributeName("src");
        return ignore;
    }
}

