/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.context.portlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.seasar.framework.container.external.portlet.PortletApplicationMap;
import org.seasar.framework.container.external.portlet.PortletInitParameterMap;
import org.seasar.framework.container.external.portlet.PortletRequestHeaderMap;
import org.seasar.framework.container.external.portlet.PortletRequestHeaderValuesMap;
import org.seasar.framework.container.external.portlet.PortletRequestMap;
import org.seasar.framework.container.external.portlet.PortletRequestParameterMap;
import org.seasar.framework.container.external.portlet.PortletRequestParameterValuesMap;
import org.seasar.framework.container.external.portlet.PortletSessionMap;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.EnumerationIterator;

public class PortletExternalContextImpl
extends ExternalContext {
    private static Logger logger = Logger.getLogger((Class)PortletExternalContextImpl.class);
    private static final String INIT_PARAMETER_MAP_ATTRIBUTE = PortletInitParameterMap.class.getName();
    private static final String SESSION_NAMESPACE = PortletExternalContextImpl.class.getName() + ".Namespace";
    private static final Map EMPTY_UNMODIFIABLE_MAP = Collections.unmodifiableMap(new HashMap(0));
    private PortletContext portletContext;
    private PortletRequest portletRequest;
    private PortletResponse portletResponse;
    private Map applicationMap;
    private Map sessionMap;
    private Map requestMap;
    private Map requestParameterMap;
    private Map requestParameterValuesMap;
    private Map requestHeaderMap;
    private Map requestHeaderValuesMap;
    private Map initParameterMap;
    private boolean isActionRequest;

    public PortletExternalContextImpl(PortletContext context, PortletRequest request, PortletResponse response) {
        this.portletContext = context;
        this.portletRequest = request;
        this.portletResponse = response;
        boolean bl = this.isActionRequest = this.portletRequest != null && this.portletRequest instanceof ActionRequest;
        if (this.isActionRequest) {
            PortletSession session;
            int charIndex;
            ActionRequest actionRequest = (ActionRequest)this.portletRequest;
            String contentType = this.portletRequest.getProperty("Content-Type");
            String characterEncoding = null;
            if (contentType != null && (charIndex = contentType.indexOf("charset=")) != -1) {
                characterEncoding = contentType.substring(charIndex + 8);
            }
            if (characterEncoding == null && (session = this.portletRequest.getPortletSession(false)) != null) {
                characterEncoding = (String)session.getAttribute("javax.faces.request.charset", 2);
            }
            if (characterEncoding != null) {
                try {
                    actionRequest.setCharacterEncoding(characterEncoding);
                }
                catch (UnsupportedEncodingException e) {
                    logger.warn((Object)("The specified encoding is wrong: " + characterEncoding), (Throwable)e);
                }
                catch (IllegalStateException e) {
                    logger.warn((Object)"setCharacterEncoding(String) must not be called after reading request parameters or reading input using getReader()", (Throwable)e);
                }
            }
        } else {
            Map sessionMap = this.getSessionMap();
            sessionMap.put(SESSION_NAMESPACE, ((RenderResponse)this.portletResponse).getNamespace());
        }
    }

    public void dispatch(String path) throws IOException {
        if (this.isActionRequest) {
            throw new IllegalStateException("Cannot call dispatch(String) if the reqeust is ActionRequest.");
        }
        PortletRequestDispatcher requestDispatcher = this.portletContext.getRequestDispatcher(path);
        try {
            requestDispatcher.include((RenderRequest)this.portletRequest, (RenderResponse)this.portletResponse);
        }
        catch (PortletException e) {
            throw new FacesException("Failed to include the content of a resource in the response.", e);
        }
    }

    public String encodeActionURL(String url) {
        AssertionUtil.assertNotNull((String)"url is null.", (Object)url);
        return this.portletResponse.encodeURL(url);
    }

    public String encodeNamespace(String name) {
        return name + this.getNamespace();
    }

    public String encodeResourceURL(String url) {
        AssertionUtil.assertNotNull((String)"url is null.", (Object)url);
        if (url.indexOf("://") == -1 && !url.startsWith("/")) {
            return url;
        }
        return this.portletResponse.encodeURL(url);
    }

    public Map getApplicationMap() {
        if (this.applicationMap == null) {
            this.applicationMap = new PortletApplicationMap(this.portletContext);
        }
        return this.applicationMap;
    }

    public String getAuthType() {
        return this.portletRequest.getAuthType();
    }

    public Object getContext() {
        return this.portletContext;
    }

    public String getInitParameter(String name) {
        return this.portletContext.getInitParameter(name);
    }

    public Map getInitParameterMap() {
        if (this.initParameterMap == null && (this.initParameterMap = (Map)this.portletContext.getAttribute(INIT_PARAMETER_MAP_ATTRIBUTE)) == null) {
            this.initParameterMap = new PortletInitParameterMap(this.portletContext);
            this.portletContext.setAttribute(INIT_PARAMETER_MAP_ATTRIBUTE, (Object)this.initParameterMap);
        }
        return this.initParameterMap;
    }

    public String getRemoteUser() {
        return this.portletRequest.getRemoteUser();
    }

    public Object getRequest() {
        return this.portletRequest;
    }

    public String getRequestContextPath() {
        return this.portletRequest.getContextPath();
    }

    public Map getRequestCookieMap() {
        return EMPTY_UNMODIFIABLE_MAP;
    }

    public Map getRequestHeaderMap() {
        if (this.requestHeaderMap == null) {
            this.requestHeaderMap = new PortletRequestHeaderMap(this.portletRequest);
        }
        return this.requestHeaderMap;
    }

    public Map getRequestHeaderValuesMap() {
        if (this.requestHeaderValuesMap == null) {
            this.requestHeaderValuesMap = new PortletRequestHeaderValuesMap(this.portletRequest);
        }
        return this.requestHeaderValuesMap;
    }

    public Locale getRequestLocale() {
        return this.portletRequest.getLocale();
    }

    public Iterator getRequestLocales() {
        return new EnumerationIterator(this.portletRequest.getLocales());
    }

    public Map getRequestMap() {
        if (this.requestMap == null) {
            this.requestMap = new PortletRequestMap(this.portletRequest);
        }
        return this.requestMap;
    }

    public Map getRequestParameterMap() {
        if (this.requestParameterMap == null) {
            this.requestParameterMap = new PortletRequestParameterMap(this.portletRequest);
        }
        return this.requestParameterMap;
    }

    public Iterator getRequestParameterNames() {
        return new EnumerationIterator(this.portletRequest.getParameterNames());
    }

    public Map getRequestParameterValuesMap() {
        if (this.requestParameterValuesMap == null) {
            this.requestParameterValuesMap = new PortletRequestParameterValuesMap(this.portletRequest);
        }
        return this.requestParameterValuesMap;
    }

    public String getRequestPathInfo() {
        return null;
    }

    public String getRequestServletPath() {
        return null;
    }

    public URL getResource(String path) throws MalformedURLException {
        AssertionUtil.assertNotNull((String)"path is null.", (Object)path);
        return this.portletContext.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        AssertionUtil.assertNotNull((String)"path is null.", (Object)path);
        return this.portletContext.getResourceAsStream(path);
    }

    public Set getResourcePaths(String path) {
        AssertionUtil.assertNotNull((String)"path is null.", (Object)path);
        return this.portletContext.getResourcePaths(path);
    }

    public Object getResponse() {
        return this.portletResponse;
    }

    public Object getSession(boolean create) {
        return this.portletRequest.getPortletSession(create);
    }

    public Map getSessionMap() {
        if (this.sessionMap == null) {
            this.sessionMap = new PortletSessionMap(this.portletRequest);
        }
        return this.sessionMap;
    }

    public Principal getUserPrincipal() {
        return this.portletRequest.getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        AssertionUtil.assertNotNull((String)"role is null.", (Object)role);
        return this.portletRequest.isUserInRole(role);
    }

    public void log(String message) {
        AssertionUtil.assertNotNull((String)"message is null.", (Object)message);
        this.portletContext.log(message);
    }

    public void log(String message, Throwable exception) {
        AssertionUtil.assertNotNull((String)"message", (Object)message);
        AssertionUtil.assertNotNull((String)"exception", (Object)exception);
        this.portletContext.log(message, exception);
    }

    public void redirect(String url) throws IOException {
        if (!(this.portletResponse instanceof ActionResponse)) {
            throw new IllegalArgumentException("RenderResponse does not support redirect(String).");
        }
        ((ActionResponse)this.portletResponse).sendRedirect(url);
    }

    protected String getNamespace() {
        if (this.isActionRequest) {
            Map sessionMap = this.getSessionMap();
            String namespace = (String)sessionMap.get(SESSION_NAMESPACE);
            if (namespace != null) {
                return namespace;
            }
            throw new IllegalStateException("Cannot call encodeNamespace(String) if the request is ActionRequest.");
        }
        return ((RenderResponse)this.portletResponse).getNamespace();
    }
}

