/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.util;

import java.io.File;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.TextUtil;

public class HotText {
    private String path;
    private String value;
    private File file;
    private long lastModified;

    public HotText() {
    }

    public HotText(String path) {
        this.setPath(path);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) throws EmptyRuntimeException {
        if (path == null) {
            throw new EmptyRuntimeException("path");
        }
        this.path = path;
        this.file = ResourceUtil.getResourceAsFileNoException(path);
        if (this.file != null) {
            this.updateValueByFile();
        } else {
            this.updateValueByPath();
        }
    }

    public String getValue() {
        if (this.isModified()) {
            this.updateValueByFile();
        }
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isModified() {
        return this.file != null && this.file.lastModified() > this.lastModified;
    }

    protected void updateValueByFile() {
        this.value = TextUtil.readUTF8(this.file);
        this.lastModified = this.file.lastModified();
    }

    protected void updateValueByPath() {
        this.value = TextUtil.readUTF8(this.path);
    }
}

