/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.util;

import java.io.IOException;
import java.security.MessageDigest;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.FacesMessageUtil;
import javax.faces.internal.scope.SubApplicationScope;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.MessageDigestUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.util.RendererUtil;

public class TransactionTokenUtil {
    public static String TOKEN = null;
    public static String SAVED_TOKEN_SUFFIX = ".SAVED";
    public static final String DEFAULT_TOKEN = TransactionTokenUtil.class.getName() + ".TOKEN";
    private static final String CURRENT_TOKEN = TransactionTokenUtil.class.getName() + ".CURRENT_TOKEN";
    public static final String PREVIOUS_TOKEN = TransactionTokenUtil.class.getName() + ".PREVIOUS_TOKEN";
    private static final String DO_ONCE = "doOnce";
    private static long previous;

    protected TransactionTokenUtil() {
    }

    public static final boolean isDoOnce(String id) {
        if (id == null) {
            return false;
        }
        return id.startsWith(DO_ONCE);
    }

    public static synchronized String getToken(Map requestMap) {
        TransactionTokenUtil.initTokenIfNeed();
        return (String)requestMap.get(TOKEN);
    }

    public static synchronized void renderTokenIfNeed(FacesContext context, UIComponent component) throws IOException {
        TransactionTokenUtil.initTokenIfNeed();
        ExternalContext extCtx = context.getExternalContext();
        Map requestMap = extCtx.getRequestMap();
        String token = (String)requestMap.get(TOKEN);
        if (!StringUtil.isEmpty((String)token)) {
            return;
        }
        token = (String)requestMap.remove(TOKEN + SAVED_TOKEN_SUFFIX);
        if (StringUtil.isEmpty((String)token)) {
            token = TransactionTokenUtil.generate(context);
        }
        requestMap.put(TOKEN, token);
        RendererUtil.renderHidden((UIComponent)component, (ResponseWriter)context.getResponseWriter(), (String)TOKEN, (Object)token);
    }

    public static synchronized void resetToken(FacesContext context) {
        if (TOKEN == null) {
            return;
        }
        ExternalContext extCtx = context.getExternalContext();
        Map requestMap = extCtx.getRequestMap();
        String token = (String)requestMap.remove(TOKEN);
        if (!StringUtil.isEmpty((String)token)) {
            requestMap.put(TOKEN + SAVED_TOKEN_SUFFIX, token);
        }
    }

    protected static String generate(FacesContext context) {
        ExternalContext extCtx = context.getExternalContext();
        Object session = extCtx.getSession(true);
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(session.getClass());
        PropertyDesc pd = beanDesc.getPropertyDesc("id");
        String id = null;
        if (pd.isReadable()) {
            id = (String)pd.getValue(session);
        }
        String token = TransactionTokenUtil.generate(id);
        TransactionTokenUtil.setCurrentToken(context, token);
        return token;
    }

    protected static String generate(String sessionId) {
        byte[] idBytes = sessionId.getBytes();
        long current = System.currentTimeMillis();
        if (current <= previous) {
            current = previous + 1L;
        }
        previous = current;
        byte[] now = Long.toString(current).getBytes();
        MessageDigest md = MessageDigestUtil.getInstance((String)"MD5");
        md.update(idBytes);
        md.update(now);
        return StringUtil.toHex((byte[])md.digest());
    }

    protected static String getCurrentToken(FacesContext context) {
        Map subAppScope = SubApplicationScope.getContext((FacesContext)context);
        if (subAppScope == null) {
            return null;
        }
        return (String)subAppScope.get(CURRENT_TOKEN);
    }

    protected static void setCurrentToken(FacesContext context, String currentToken) {
        Map subAppScope = SubApplicationScope.getOrCreateContext((FacesContext)context);
        subAppScope.put(CURRENT_TOKEN, currentToken);
    }

    protected static void removeCurrentTokens(FacesContext context) {
        Map subAppScope = SubApplicationScope.getContext((FacesContext)context);
        if (subAppScope == null) {
            return;
        }
        subAppScope.remove(CURRENT_TOKEN);
    }

    protected static String getPreviousToken(FacesContext context) {
        Map subAppScope = SubApplicationScope.getContext((FacesContext)context);
        if (subAppScope == null) {
            return null;
        }
        return (String)subAppScope.get(PREVIOUS_TOKEN);
    }

    protected static void setPreviousToken(FacesContext context, String previousToken) {
        Map subAppScope = SubApplicationScope.getOrCreateContext((FacesContext)context);
        subAppScope.put(PREVIOUS_TOKEN, previousToken);
    }

    protected static void removePreviousToken(FacesContext context) {
        Map subAppScope = SubApplicationScope.getContext((FacesContext)context);
        if (subAppScope == null) {
            return;
        }
        subAppScope.remove(PREVIOUS_TOKEN);
    }

    public static synchronized boolean verify(FacesContext context) {
        TransactionTokenUtil.initTokenIfNeed();
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        String token = TransactionTokenUtil.getToken(requestMap);
        if (StringUtil.isEmpty((String)token)) {
            return false;
        }
        return TransactionTokenUtil.verify(context, token);
    }

    public static synchronized boolean verify(FacesContext context, String token) {
        String currentToken = TransactionTokenUtil.getCurrentToken(context);
        if (StringUtil.isEmpty((String)currentToken)) {
            return false;
        }
        if (currentToken.equals(token)) {
            TransactionTokenUtil.removeCurrentTokens(context);
            TransactionTokenUtil.setPreviousToken(context, token);
            return true;
        }
        return false;
    }

    public static boolean isPrevious(FacesContext context) {
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String token = (String)paramMap.get(TOKEN);
        String previous = TransactionTokenUtil.getPreviousToken(context);
        if (StringUtil.isEmpty((String)previous)) {
            return false;
        }
        return previous.equals(token);
    }

    private static void initTokenIfNeed() {
        if (TOKEN == null) {
            String customizedTokenKey = FacesMessageUtil.getSummary((FacesContext)FacesContext.getCurrentInstance(), (String)DEFAULT_TOKEN, null);
            TOKEN = customizedTokenKey != null ? customizedTokenKey : DEFAULT_TOKEN;
        }
    }

    public static void resetContext(FacesContext context) {
        TransactionTokenUtil.removeCurrentTokens(context);
        TransactionTokenUtil.removePreviousToken(context);
    }
}

