/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.IgnoreAttribute;
import javax.faces.internal.LabelUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.core.util.ValueHolderUtil;
import org.seasar.teeda.extension.component.html.THtmlOutputLabel;

public class THtmlOutputLabelRenderer
extends AbstractRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Output";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.Label";
    private static final IgnoreAttribute IGNORE_COMPONENT = THtmlOutputLabelRenderer.buildIgnoreComponent();

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeTHtmlOutputLabelBegin(context, (THtmlOutputLabel)component);
    }

    protected void encodeTHtmlOutputLabelBegin(FacesContext context, THtmlOutputLabel label) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("label", (UIComponent)label);
        RendererUtil.renderIdAttributeIfNecessary((ResponseWriter)writer, (UIComponent)label, (String)this.getIdForRender(context, (UIComponent)label));
        String forAttr = label.getFor();
        if (forAttr != null) {
            UIComponent forComponent = label.findComponent(forAttr);
            if (forComponent == null) {
                throw new IllegalStateException("for Component [" + forAttr + "] does not found");
            }
            String forId = this.getIdForRender(context, forComponent);
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"for", (Object)forId, null);
        }
        this.renderRemainAttributes((UIComponent)label, writer, IGNORE_COMPONENT);
        String value = ValueHolderUtil.getValueForRender((FacesContext)context, (UIComponent)label);
        if (StringUtil.isEmpty((String)value)) {
            String key = label.getKey();
            String propertiesName = label.getPropertiesName();
            String defaultKey = label.getDefaultKey();
            String defaultPropertiesName = label.getDefaultPropertiesName();
            value = LabelUtil.getLabelValue((String)key, (String)propertiesName, (String)defaultKey, (String)defaultPropertiesName);
        }
        if (StringUtil.isEmpty((String)value)) {
            value = label.getTemplateValue();
        }
        if (value != null) {
            writer.writeText((Object)value, null);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeTHtmlOutputLabelEnd(context, (THtmlOutputLabel)component);
    }

    protected void encodeTHtmlOutputLabelEnd(FacesContext context, THtmlOutputLabel label) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("label");
    }

    protected static IgnoreAttribute buildIgnoreComponent() {
        IgnoreAttribute ignore = new IgnoreAttribute();
        ignore.addAttributeName("for");
        ignore.addAttributeName("id");
        ignore.addAttributeName("value");
        ignore.addAttributeName("key");
        ignore.addAttributeName("propertiesName");
        ignore.addAttributeName("propertiesName");
        ignore.addAttributeName("defaultKey");
        ignore.addAttributeName("defaultPropertiesName");
        ignore.addAttributeName("templateValue");
        return ignore;
    }
}

