/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.application;

import javax.faces.application.StateManager;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import org.seasar.teeda.core.application.TreeStructureManager;

public abstract class TeedaStateManager
extends StateManager {
    protected static final String SERIALIZED_VIEW_ATTR = TeedaStateManager.class.getName() + ".SERIALIZED_VIEW";
    private TreeStructureManager treeStructureManager;

    public TreeStructureManager getTreeStructureManager() {
        return this.treeStructureManager;
    }

    public void setTreeStructureManager(TreeStructureManager treeStructureManager) {
        this.treeStructureManager = treeStructureManager;
    }

    public abstract void removeSerializedView(String var1);

    public void saveViewToServer(FacesContext context, UIViewRoot viewRoot) throws IllegalStateException {
        StateManager.SerializedView serializedView = this.createSerializedView(context, viewRoot);
        this.saveSerializedViewToServer(context, viewRoot.getViewId(), serializedView);
    }

    public Object getComponentStateToSave(FacesContext context, UIViewRoot viewRoot) {
        if (viewRoot.isTransient()) {
            return null;
        }
        return viewRoot.processSaveState(context);
    }

    public Object getTreeStructureToSave(FacesContext context, UIViewRoot viewRoot) {
        if (viewRoot.isTransient()) {
            return null;
        }
        return this.getTreeStructureManager().buildTreeStructure(viewRoot);
    }

    protected StateManager.SerializedView createSerializedView(FacesContext context) {
        Object struct = this.getTreeStructureToSave(context);
        Object state = this.getComponentStateToSave(context);
        return new StateManager.SerializedView(struct, state);
    }

    protected StateManager.SerializedView createSerializedView(FacesContext context, UIViewRoot viewRoot) {
        Object struct = this.getTreeStructureToSave(context, viewRoot);
        Object state = this.getComponentStateToSave(context, viewRoot);
        return new StateManager.SerializedView(struct, state);
    }

    protected abstract void saveSerializedViewToServer(FacesContext var1, String var2, StateManager.SerializedView var3);

    public abstract boolean hasSerializedView(FacesContext var1, String var2);
}

