/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.jdbc.impl;

import java.util.LinkedList;
import org.seasar.extension.jdbc.SqlLog;
import org.seasar.extension.jdbc.SqlLogRegistry;

public class SqlLogRegistryImpl
implements SqlLogRegistry {
    private static final int DEFAULT_LIMIT_SIZE = 3;
    private int limitSize;
    private ThreadLocal threadList = new ThreadLocal();

    public SqlLogRegistryImpl() {
        this(3);
    }

    public SqlLogRegistryImpl(int limitSize) {
        this.limitSize = limitSize;
    }

    public int getLimitSize() {
        return this.limitSize;
    }

    public int getSize() {
        return this.getSqlLogList().size();
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public SqlLog get(int index) {
        return (SqlLog)this.getSqlLogList().get(index);
    }

    public SqlLog getLast() {
        return this.isEmpty() ? null : (SqlLog)this.getSqlLogList().getLast();
    }

    public void add(SqlLog sqlLog) {
        if (this.limitSize <= 0) {
            return;
        }
        LinkedList list = this.getSqlLogList();
        list.add(sqlLog);
        if (list.size() > this.limitSize) {
            list.removeFirst();
        }
    }

    public void clear() {
        this.getSqlLogList().clear();
    }

    private LinkedList getSqlLogList() {
        LinkedList list = (LinkedList)this.threadList.get();
        if (list == null) {
            list = new LinkedList();
            this.threadList.set(list);
        }
        return list;
    }
}

