/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.IgnoreAttribute;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.render.AbstractRenderer;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.extension.component.html.THtmlScript;
import org.seasar.teeda.extension.util.PathUtil;
import org.seasar.teeda.extension.util.VirtualResource;

public class THtmlScriptRenderer
extends AbstractRenderer {
    public static final String COMPONENT_FAMILY = "org.seasar.teeda.extension.HtmlScript";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.HtmlScript";
    private static final IgnoreAttribute IGNORE_COMPONENT = THtmlScriptRenderer.buildIgnoreComponent();

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeTHtmlScriptBegin(context, (THtmlScript)component);
    }

    protected void encodeTHtmlScriptBegin(FacesContext context, THtmlScript script) throws IOException {
        String src;
        String lang;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("script", (UIComponent)script);
        RendererUtil.renderIdAttributeIfNecessary((ResponseWriter)writer, (UIComponent)script, (String)this.getIdForRender(context, (UIComponent)script));
        String type = script.getType();
        if (!StringUtil.isEmpty((String)type)) {
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"type", (Object)type, null);
        }
        if (!StringUtil.isEmpty((String)(lang = script.getLanguage()))) {
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"language", (Object)lang, null);
        }
        if (!StringUtil.isEmpty((String)(src = script.getSrc()))) {
            if (VirtualResource.startsWithVirtualPath(src)) {
                src = context.getExternalContext().getRequestContextPath() + src;
            } else {
                String baseViewId = script.getBaseViewId();
                src = PathUtil.toAbsolutePath(context, src, baseViewId);
            }
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"src", (Object)src, null);
        }
        this.renderRemainAttributes((UIComponent)script, writer, IGNORE_COMPONENT);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.assertNotNull(context, component);
        if (!component.isRendered()) {
            return;
        }
        this.encodeTHtmlScriptEnd(context, (THtmlScript)component);
    }

    protected void encodeTHtmlScriptEnd(FacesContext context, THtmlScript script) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        writer.endElement("script");
    }

    protected static IgnoreAttribute buildIgnoreComponent() {
        IgnoreAttribute ignore = new IgnoreAttribute();
        ignore.addAttributeName("type");
        ignore.addAttributeName("language");
        ignore.addAttributeName("src");
        ignore.addAttributeName("baseViewId");
        return ignore;
    }
}

