/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.core.util;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.iterators.IteratorChain;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.framework.util.EmptyIterator;
import org.seasar.framework.util.EnumerationIterator;

public class IteratorUtil {
    private static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();

    private IteratorUtil() {
    }

    public static Iterator getIterator(Collection collection) {
        if (collection != null && !collection.isEmpty()) {
            return collection.iterator();
        }
        return EMPTY_ITERATOR;
    }

    public static Iterator getEntryIterator(Map map) {
        if (map != null && !map.isEmpty()) {
            return map.entrySet().iterator();
        }
        return EMPTY_ITERATOR;
    }

    public static Iterator getCompositeIterator(Map map1, Map map2) {
        IteratorChain chain = new IteratorChain();
        chain.addIterator(map1.keySet().iterator());
        chain.addIterator(map2.keySet().iterator());
        return chain;
    }

    public static Iterator getResourcesIterator(ClassLoader loader, String path) {
        try {
            Enumeration<URL> e = loader.getResources(path);
            return new EnumerationIterator(e);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

