/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.model;

import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;

public class ArrayDataModel
extends DataModel {
    private Object[] array = null;
    private int index = -1;

    public ArrayDataModel() {
        this(null);
    }

    public ArrayDataModel(Object[] array) {
        this.setWrappedData(array);
    }

    public int getRowCount() {
        return this.array != null ? this.array.length : -1;
    }

    public Object getRowData() {
        if (this.array == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException();
        }
        return this.array[this.index];
    }

    public int getRowIndex() {
        return this.index;
    }

    public Object getWrappedData() {
        return this.array;
    }

    public boolean isRowAvailable() {
        if (this.array == null) {
            return false;
        }
        return this.index >= 0 && this.index < this.array.length;
    }

    public void setWrappedData(Object data) {
        this.array = (Object[])data;
        int index = data != null ? 0 : -1;
        this.setRowIndex(index);
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        int oldIndex = this.index;
        this.index = rowIndex;
        if (this.array == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (oldIndex != this.index && listeners != null) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event = new DataModelEvent(this, this.index, rowData);
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].rowSelected(event);
            }
        }
    }
}

