/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.teeda.core.util.BindingUtil;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.extension.component.html.THtmlElement;

public class THtmlElementRenderer
extends Renderer {
    public static final String COMPONENT_FAMILY = "org.seasar.teeda.extension.HtmlElement";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.HtmlElement";

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)component);
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        if (!(component instanceof THtmlElement)) {
            throw new IllegalArgumentException("not THtmlElement");
        }
        THtmlElement elem = (THtmlElement)component;
        String tagName = elem.getTagName();
        writer.startElement(tagName, component);
        this.renderAttributes(writer, elem);
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)component);
        THtmlElement elem = (THtmlElement)component;
        ResponseWriter writer = context.getResponseWriter();
        if (component.isRendered()) {
            writer.endElement(elem.getTagName());
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        AssertionUtil.assertNotNull((String)"component", (Object)component);
        if (!component.isRendered()) {
            return;
        }
        RendererUtil.renderChildren((FacesContext)context, (UIComponent)component);
    }

    protected void renderAttributes(ResponseWriter writer, THtmlElement component) throws IOException {
        if (component.isIdSet()) {
            String id = component.getId();
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)"id", (Object)id, (String)"id");
        }
        Map attrs = component.getAttributes();
        Iterator i = attrs.keySet().iterator();
        while (i.hasNext()) {
            String attrName = (String)i.next();
            if (attrName.indexOf(46) > 0) continue;
            Object value = component.getAttributes().get(attrName);
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)attrName, value, (String)attrName);
        }
        String[] bindingPropertyNames = component.getBindingPropertyNames();
        for (int i2 = 0; i2 < bindingPropertyNames.length; ++i2) {
            String name = bindingPropertyNames[i2];
            Object value = BindingUtil.getBindingValue((UIComponent)component, (String)name);
            RendererUtil.renderAttribute((ResponseWriter)writer, (String)name, (Object)value, (String)name);
        }
    }
}

