/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.impl;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.teeda.extension.ExtensionConstants;
import org.seasar.teeda.extension.annotation.handler.ConverterAnnotationHandlerFactory;
import org.seasar.teeda.extension.annotation.handler.FacesMessageAnnotationHandlerFactory;
import org.seasar.teeda.extension.annotation.handler.RedirectDescAnnotationHandlerFactory;
import org.seasar.teeda.extension.annotation.handler.ScopeAnnotationHandlerFactory;
import org.seasar.teeda.extension.annotation.handler.TakeOverDescAnnotationHandlerFactory;
import org.seasar.teeda.extension.annotation.handler.ValidatorAnnotationHandlerFactory;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.RedirectDesc;
import org.seasar.teeda.extension.html.TakeOverDesc;
import org.seasar.teeda.extension.html.impl.ActionDescUtil;

public class PageDescImpl
implements PageDesc,
Serializable {
    private static final long serialVersionUID = 1L;
    private String pageName;
    private Set propertyNames = new HashSet();
    private Set itemsPropertyNames = new HashSet();
    private Set mapItemsPropertyNames = new HashSet();
    private Set dynamicPropertyNames = new HashSet();
    private Set methodNames;
    private Map takeOverDescs;
    private Map propertyScopes;
    private Map redirectDescs;
    private File file;
    private long lastModified;
    private static final String[] EMPTY_SCOPES = new String[0];

    public PageDescImpl(Class pageClass, String pageName) {
        this(pageClass, pageName, null);
    }

    public PageDescImpl(Class pageClass, String pageName, File file) {
        this.pageName = pageName;
        this.setup(pageClass);
        if (file != null) {
            this.file = file;
            this.lastModified = file.lastModified();
        }
    }

    public String getPageName() {
        return this.pageName;
    }

    protected void setup(Class pageClass) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc((Class)pageClass);
        for (int i = 0; i < beanDesc.getPropertyDescSize(); ++i) {
            PropertyDesc pd = beanDesc.getPropertyDesc(i);
            if (this.isItemsProperty(pd)) {
                this.itemsPropertyNames.add(pd.getPropertyName());
            }
            if (this.isMapItemsProperty(pd)) {
                this.mapItemsPropertyNames.add(pd.getPropertyName());
            }
            this.propertyNames.add(pd.getPropertyName());
            if (!this.isDynamicProperty(pd)) continue;
            this.dynamicPropertyNames.add(pd.getPropertyName());
        }
        this.methodNames = ActionDescUtil.getActionMethodNames(pageClass);
        String pageName = this.getPageName();
        this.handleAnnotations(pageName);
    }

    protected void handleAnnotations(String pageName) {
        ValidatorAnnotationHandlerFactory.getAnnotationHandler().registerValidators(pageName);
        ConverterAnnotationHandlerFactory.getAnnotationHandler().registerConverters(pageName);
        this.takeOverDescs = TakeOverDescAnnotationHandlerFactory.getAnnotationHandler().getTakeOverDescs(pageName);
        this.propertyScopes = ScopeAnnotationHandlerFactory.getAnnotationHandler().getPropertyScopes(pageName);
        this.redirectDescs = RedirectDescAnnotationHandlerFactory.getAnnotationHandler().getRedirectDescs(pageName);
        FacesMessageAnnotationHandlerFactory.getAnnotationHandler().registerFacesMessages(pageName);
    }

    protected boolean isItemsProperty(PropertyDesc pd) {
        if (!pd.getPropertyName().endsWith("Items")) {
            return false;
        }
        Class clazz = pd.getPropertyType();
        return clazz.isArray() || Collection.class.isAssignableFrom(clazz);
    }

    protected boolean isMapItemsProperty(PropertyDesc pd) {
        if (!pd.getPropertyName().endsWith("Items")) {
            return false;
        }
        Class clazz = pd.getPropertyType();
        return Map.class.isAssignableFrom(clazz);
    }

    protected boolean isDynamicProperty(PropertyDesc pd) {
        return pd.isReadable();
    }

    public boolean isRedirectScopeProperty(String name) {
        Integer scope = (Integer)this.propertyScopes.get(name);
        if (scope == null) {
            return false;
        }
        return ExtensionConstants.REDIRECT_SCOPE.equals(scope);
    }

    public boolean isSubapplicationScopeProperty(String name) {
        Integer scope = (Integer)this.propertyScopes.get(name);
        if (scope == null) {
            return false;
        }
        return ExtensionConstants.SUBAPP_SCOPE.equals(scope);
    }

    public boolean isPageScopeProperty(String name) {
        Integer scope = (Integer)this.propertyScopes.get(name);
        if (scope == null) {
            return false;
        }
        return ExtensionConstants.PAGE_SCOPE.equals(scope);
    }

    public boolean hasProperty(String name) {
        return this.propertyNames.contains(name);
    }

    public boolean hasItemsProperty(String name) {
        return this.itemsPropertyNames.contains(name);
    }

    public boolean hasMapItemsProperty(String name) {
        return this.mapItemsPropertyNames.contains(name);
    }

    public boolean hasDynamicProperty(String name) {
        return this.dynamicPropertyNames.contains(name);
    }

    public boolean hasMethod(String name) {
        return this.methodNames.contains(name);
    }

    public TakeOverDesc getTakeOverDesc(String methodName) {
        if (!this.hasTakeOverDesc(methodName)) {
            throw new IllegalArgumentException(methodName);
        }
        return (TakeOverDesc)this.takeOverDescs.get(methodName);
    }

    public boolean hasTakeOverDesc(String methodName) {
        return this.takeOverDescs.containsKey(methodName);
    }

    public boolean hasRedirectDesc(String methodName) {
        return this.redirectDescs.containsKey(methodName);
    }

    public RedirectDesc getRedirectDesc(String methodName) {
        if (!this.hasRedirectDesc(methodName)) {
            throw new IllegalArgumentException(methodName);
        }
        return (RedirectDesc)this.redirectDescs.get(methodName);
    }

    public boolean isModified() {
        if (this.file == null) {
            return false;
        }
        if (!this.file.exists()) {
            return true;
        }
        return this.file.lastModified() != this.lastModified;
    }

    public String[] getPageScopePropertyNames() {
        return this.getScopePropertyNames(ExtensionConstants.PAGE_SCOPE);
    }

    public String[] getRedirectScopePropertyNames() {
        return this.getScopePropertyNames(ExtensionConstants.REDIRECT_SCOPE);
    }

    public String[] getSubapplicationScopePropertyNames() {
        return this.getScopePropertyNames(ExtensionConstants.SUBAPP_SCOPE);
    }

    protected String[] getScopePropertyNames(Integer targetScope) {
        if (this.propertyScopes == null) {
            return EMPTY_SCOPES;
        }
        ArrayList list = new ArrayList();
        Iterator itr = this.propertyScopes.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            Integer scope = (Integer)entry.getValue();
            if (!targetScope.equals(scope)) continue;
            list.add(entry.getKey());
        }
        return list.toArray(new String[list.size()]);
    }

    public boolean hasPageScopeProperty() {
        return this.propertyScopes.containsValue(ExtensionConstants.PAGE_SCOPE);
    }

    public boolean hasRedirectScopeProperty() {
        return this.propertyScopes.containsValue(ExtensionConstants.REDIRECT_SCOPE);
    }

    public boolean hasSubapplicationScopeProperty() {
        return this.propertyScopes.containsValue(ExtensionConstants.SUBAPP_SCOPE);
    }
}

