/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.html.factory;

import java.util.Map;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.html.ActionDesc;
import org.seasar.teeda.extension.html.ElementNode;
import org.seasar.teeda.extension.html.PageDesc;
import org.seasar.teeda.extension.html.factory.InputTextFactory;

public class InputDateTextFactory
extends InputTextFactory {
    private static final String TAG_NAME = "inputDateText";

    public boolean isMatch(ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        String classProperty = elementNode.getProperty("class");
        boolean isInputTextMatch = super.isMatch(elementNode, pageDesc, actionDesc);
        if (!isInputTextMatch) {
            return false;
        }
        boolean hasTdate = StringUtil.startsWithIgnoreCase((String)classProperty, (String)"T_date");
        return classProperty != null && hasTdate;
    }

    protected void customizeProperties(Map properties, ElementNode elementNode, PageDesc pageDesc, ActionDesc actionDesc) {
        super.customizeProperties(properties, elementNode, pageDesc, actionDesc);
        if (pageDesc == null) {
            return;
        }
        String pattern = elementNode.getProperty("pattern");
        if (pattern == null) {
            pattern = this.getBindingExpression(pageDesc.getPageName(), elementNode.getId() + "Pattern");
        }
        properties.put("pattern", pattern);
        String length = elementNode.getProperty("length");
        if (length == null) {
            length = this.getBindingExpression(pageDesc.getPageName(), elementNode.getId() + "Length");
        }
        properties.put("length", length);
        String threshold = elementNode.getProperty("threshold");
        if (threshold == null) {
            threshold = this.getBindingExpression(pageDesc.getPageName(), elementNode.getId() + "Threshold");
        }
        properties.put("threshold", threshold);
    }

    protected String getTagName() {
        return TAG_NAME;
    }

    protected String getUri() {
        return "http://www.seasar.org/teeda/extension";
    }
}

