/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.extension.filter.MultipartFormDataRequestWrapper;

public class MultipartFormDataFilter
implements Filter {
    public static final String DOFILTER_CALLED = "org.seasar.teeda.extension.filter.MultipartFormDataFilter.doFilterCalled";
    public static final int DEFAULT_MAX_SIZE = 0x6400000;
    public static final int DEFAULT_MAX_FILE_SIZE = 0x6400000;
    public static final int DEFAULT_THREASHOLD_SIZe = 102400;
    protected int maxSize;
    protected int maxFileSize;
    protected int thresholdSize;
    protected String repositoryPath = null;
    protected ServletContext servletContext;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.maxSize = this.getSizeParameter(filterConfig, "uploadMaxSize", 0x6400000);
        this.maxFileSize = this.getSizeParameter(filterConfig, "uploadMaxFileSize", 0x6400000);
        this.thresholdSize = this.getSizeParameter(filterConfig, "uploadThresholdSize", 102400);
        this.repositoryPath = filterConfig.getInitParameter("uploadRepositoryPath");
        this.servletContext = filterConfig.getServletContext();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request.getAttribute(DOFILTER_CALLED) != null) {
            chain.doFilter(request, response);
            return;
        }
        request.setAttribute(DOFILTER_CALLED, (Object)"true");
        if (!(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)httpRequest)) {
            chain.doFilter(request, response);
            return;
        }
        MultipartFormDataRequestWrapper multipartRequest = new MultipartFormDataRequestWrapper(httpRequest, this.maxSize, this.maxFileSize, this.thresholdSize, this.repositoryPath);
        chain.doFilter((ServletRequest)multipartRequest, response);
    }

    public void destroy() {
    }

    protected int getSizeParameter(FilterConfig filterConfig, String parameterName, int defaultValue) {
        String param = filterConfig.getInitParameter(parameterName);
        if (StringUtil.isEmpty((String)param)) {
            return defaultValue;
        }
        param = param.toLowerCase();
        int factor = 1;
        String number = param;
        if (param.endsWith("g")) {
            factor = 0x40000000;
            number = param.substring(0, param.length() - 1);
        } else if (param.endsWith("m")) {
            factor = 0x100000;
            number = param.substring(0, param.length() - 1);
        } else if (param.endsWith("k")) {
            factor = 1024;
            number = param.substring(0, param.length() - 1);
        }
        return Integer.parseInt(number) * factor;
    }
}

