/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.teeda.extension.render.html;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIInput;
import javax.faces.component.html.HtmlInputText;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.internal.FacesMessageUtil;
import org.seasar.framework.util.AssertionUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.teeda.core.render.html.HtmlInputTextRenderer;
import org.seasar.teeda.core.util.RendererUtil;
import org.seasar.teeda.extension.component.html.THtmlInputText;

public class THtmlInputTextRenderer
extends HtmlInputTextRenderer {
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    public static final String RENDERER_TYPE = "org.seasar.teeda.extension.HtmlInputText";

    public THtmlInputTextRenderer() {
        this.addIgnoreAttributeName("errorStyleClass");
    }

    protected void renderStyleClass(FacesContext context, HtmlInputText htmlInputText, ResponseWriter writer) throws IOException {
        this.colorErrorComponent(context, (UIInput)htmlInputText);
    }

    protected void colorErrorComponent(FacesContext context, UIInput input) throws IOException {
        AssertionUtil.assertNotNull((String)"context", (Object)context);
        THtmlInputText htmlInputText = (THtmlInputText)input;
        ResponseWriter writer = context.getResponseWriter();
        String clientId = htmlInputText.getClientId(context);
        String styleClass = htmlInputText.getStyleClass();
        if (FacesMessageUtil.hasMessagesByClientId((FacesContext)context, (String)clientId) || this.containsClientId(context, clientId)) {
            String errorCss = htmlInputText.getErrorStyleClass();
            if (StringUtil.isEmpty((String)errorCss)) {
                return;
            }
            if (styleClass != null && styleClass.indexOf(errorCss) >= 0) {
                return;
            }
            styleClass = styleClass != null ? styleClass + " " + errorCss : errorCss;
        }
        RendererUtil.renderAttribute((ResponseWriter)writer, (String)"styleClass", (Object)styleClass);
    }

    protected boolean containsClientId(FacesContext context, String clientId) {
        ExternalContext externalContext = context.getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        Set clientIds = (Set)requestMap.get("org.seasar.teeda.extension.message.clientids");
        return clientIds != null && clientIds.contains(clientId);
    }
}

