/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.internal;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import org.seasar.framework.util.AssertionUtil;

public class ComponentFacetMapWrapper
implements Map,
Serializable {
    private static final long serialVersionUID = 3977016266726585651L;
    private UIComponent parent = null;
    private Map facetMap = new HashMap();

    public ComponentFacetMapWrapper(UIComponent parent) {
        this.parent = parent;
    }

    public int size() {
        return this.facetMap.size();
    }

    public void clear() {
        this.facetMap.clear();
    }

    public boolean isEmpty() {
        return this.facetMap.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.facetMap.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.facetMap.containsValue(value);
    }

    public Collection values() {
        return this.facetMap.values();
    }

    public Set entrySet() {
        return this.facetMap.entrySet();
    }

    public Set keySet() {
        return this.facetMap.keySet();
    }

    public Object get(Object key) {
        return this.facetMap.get(key);
    }

    public Object remove(Object key) {
        UIComponent facet = (UIComponent)this.facetMap.remove(key);
        if (facet != null) {
            facet.setParent(null);
        }
        return facet;
    }

    public Object put(Object key, Object facet) {
        AssertionUtil.assertNotNull((String)"key", (Object)key);
        AssertionUtil.assertNotNull((String)"facet", (Object)facet);
        ComponentFacetMapWrapper.checkKeyClass(key);
        ComponentFacetMapWrapper.checkValueClass(facet);
        this.setNewParent((String)key, (UIComponent)facet);
        return this.facetMap.put(key, facet);
    }

    public void putAll(Map map) {
        Iterator itr = map.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    private void setNewParent(String facetName, UIComponent facet) {
        UIComponent oldParent = facet.getParent();
        if (oldParent != null) {
            oldParent.getFacets().remove(facetName);
        }
        facet.setParent(this.parent);
    }

    private static void checkKeyClass(Object key) {
        if (!(key instanceof String)) {
            throw new ClassCastException("key");
        }
    }

    private static void checkValueClass(Object value) {
        if (!(value instanceof UIComponent)) {
            throw new ClassCastException("value");
        }
    }
}

