/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.util.io;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.Iterator;
import org.seasar.util.exception.SNoSuchElementException;
import org.seasar.util.exception.SUnsupportedOperationException;
import org.seasar.util.io.ReaderUtil;
import org.seasar.util.misc.AssertionUtil;

public class LineIterator
implements Iterator<String> {
    protected static final String EMPTY = new String();
    protected final BufferedReader reader;
    protected String line = EMPTY;

    public static Iterable<String> iterable(Reader reader) {
        AssertionUtil.assertArgumentNotNull("reader", reader);
        return LineIterator.iterable(new BufferedReader(reader));
    }

    public static Iterable<String> iterable(final BufferedReader reader) {
        AssertionUtil.assertArgumentNotNull("reader", reader);
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new LineIterator(reader);
            }
        };
    }

    public LineIterator(Reader reader) {
        AssertionUtil.assertArgumentNotNull("reader", reader);
        this.reader = new BufferedReader(reader);
    }

    public LineIterator(BufferedReader reader) {
        AssertionUtil.assertArgumentNotNull("reader", reader);
        this.reader = reader;
    }

    @Override
    public boolean hasNext() {
        if (this.line == EMPTY) {
            this.line = ReaderUtil.readLine(this.reader);
        }
        return this.line != null;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            throw new SNoSuchElementException();
        }
        String result = this.line;
        this.line = EMPTY;
        return result;
    }

    @Override
    public void remove() {
        throw new SUnsupportedOperationException("remove");
    }
}

