/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.message.Message;
import org.h2.table.Table;
import org.h2.util.StringUtils;

public class Comment
extends DbObject {
    private int type;
    private boolean column;
    private String fullName;
    private String commentText;

    public Comment(Database database, int id, int type, boolean column, String fullName) {
        super(database, id, Comment.getKey(type, column, fullName), "database");
        this.type = type;
        this.fullName = fullName;
        this.column = column;
    }

    public String getCreateSQLForCopy(Table table, String quotedName) {
        throw Message.internal();
    }

    private static String getTypeName(int type, boolean column) {
        switch (type) {
            case 11: {
                return "CONSTANT";
            }
            case 5: {
                return "CONSTRAINT";
            }
            case 9: {
                return "ALIAS";
            }
            case 1: {
                return "INDEX";
            }
            case 7: {
                return "ROLE";
            }
            case 10: {
                return "SCHEMA";
            }
            case 3: {
                return "SEQUENCE";
            }
            case 0: {
                if (column) {
                    return "COLUMN";
                }
                return "TABLE";
            }
            case 4: {
                return "TRIGGER";
            }
            case 2: {
                return "USER";
            }
            case 12: {
                return "DOMAIN";
            }
        }
        throw Message.internal();
    }

    public String getCreateSQL() {
        StringBuffer buff = new StringBuffer();
        buff.append("COMMENT ON ");
        buff.append(Comment.getTypeName(this.type, this.column));
        buff.append(' ');
        buff.append(this.fullName);
        buff.append(" IS ");
        if (this.commentText == null) {
            buff.append("NULL");
        } else {
            buff.append(StringUtils.quoteStringSQL(this.commentText));
        }
        return buff.toString();
    }

    public int getType() {
        return 13;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
    }

    public void checkRename() throws SQLException {
        throw Message.internal();
    }

    public static String getKey(int objectType, boolean column, String fullName) {
        return Comment.getTypeName(objectType, column) + " " + fullName;
    }

    public void setCommentText(String comment) {
        this.commentText = comment;
    }
}

