/*
 * Copyright 2004-2006 H2 Group. Licensed under the H2 License, Version 1.0 (http://h2database.com/html/license.html).
 * Initial Developer: H2 Group
 */
package org.h2.engine;

import java.sql.SQLException;

import org.h2.message.Message;
import org.h2.message.Trace;
import org.h2.table.Table;
import org.h2.util.StringUtils;

public class Comment extends DbObject {

    private int type;
    private boolean column;
    private String fullName;
    private String commentText;

    public Comment(Database database, int id, int type, boolean column, String fullName) {
        super(database, id,  getKey(type, column, fullName), Trace.DATABASE);
        this.type = type;
        this.fullName = fullName;
        this.column = column;
    }

    public String getCreateSQLForCopy(Table table, String quotedName) {
        throw Message.internal();
    }

    private static String getTypeName(int type, boolean column) {
        switch(type) {
        case DbObject.CONSTANT:
            return "CONSTANT";
        case DbObject.CONSTRAINT:
            return "CONSTRAINT";
        case DbObject.FUNCTION_ALIAS:
            return "ALIAS";
        case DbObject.INDEX:
            return "INDEX";
        case DbObject.ROLE:
            return "ROLE";
        case DbObject.SCHEMA:
            return "SCHEMA";
        case DbObject.SEQUENCE:
            return "SEQUENCE";
        case DbObject.TABLE_OR_VIEW:
            if(column) {
                return "COLUMN";
            } else {
                return "TABLE";
            }
        case DbObject.TRIGGER:
            return "TRIGGER";
        case DbObject.USER:
            return "USER";
        case DbObject.USER_DATATYPE:
            return "DOMAIN";
        default:
            throw Message.internal();
        }
    }

    public String getCreateSQL() {
        StringBuffer buff = new StringBuffer();
        buff.append("COMMENT ON ");
        buff.append(getTypeName(type, column));
        buff.append(' ');
        buff.append(fullName);
        buff.append(" IS ");
        if(commentText == null) {
            buff.append("NULL");
        } else {
            buff.append(StringUtils.quoteStringSQL(commentText));
        }
        return buff.toString();
    }

    public int getType() {
        return DbObject.COMMENT;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
    }

    public void checkRename() throws SQLException {
        throw Message.internal();
    }

    public static String getKey(int objectType, boolean column, String fullName) {
        return getTypeName(objectType, column) + " " + fullName;
    }

    public void setCommentText(String comment) {
        this.commentText = comment;
    }

}
