/*
 * Copyright 2004-2006 H2 Group. Licensed under the H2 License, Version 1.0 (http://h2database.com/html/license.html). 
 * Initial Developer: H2 Group 
 */
package org.h2.util;

import java.math.BigDecimal;
import java.sql.SQLException;

import org.h2.engine.Constants;
import org.h2.message.Message;

/**
 * @author Thomas
 */

public class MathUtils {
    // with blockSizePowerOf2 8: 0 > 0; 1..8 > 8, 9..16 > 16, ...
    public static int roundUp(int x, int blockSizePowerOf2) {
        return (x + blockSizePowerOf2 - 1) & (-blockSizePowerOf2);   
    }
    
    public static long scaleUp50Percent(long start, long min, long blockSize) {
        while(start < min) {
            start += start / 2;
            start += start % blockSize;                    
        }
        return start;
    }
    
    public static BigDecimal setScale(BigDecimal bd, int scale) throws SQLException {
        if(scale > Constants.BIGDECIMAL_SCALE_MAX) {
            throw Message.getInvalidValueException(""+scale, "scale");
        } else if(scale < 0) {
            throw Message.getInvalidValueException(""+scale, "scale");
        }
        return bd.setScale(scale, BigDecimal.ROUND_HALF_UP);
    }
    
    public static int convertLongToInt(long l) {
        if(l<=Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        } else if(l>=Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        } else {
            return (int) l;
        }
    }
}
