/*
 * Copyright 2004-2006 H2 Group. Licensed under the H2 License, Version 1.0 (http://h2database.com/html/license.html).
 * Initial Developer: H2 Group
 */
package org.h2.jdbc;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.BatchUpdateException;
import java.sql.SQLException;

public class JdbcBatchUpdateException extends BatchUpdateException {

    private static final long serialVersionUID = 9006432914018679675L;
    
    /**
     * INTERNAL
     */
    public JdbcBatchUpdateException(SQLException next, int[] updateCounts) {
        super(next.getMessage(), next.getSQLState(), next.getErrorCode(), updateCounts);
    }

    /**
     * INTERNAL
     */
    public void printStackTrace() {
        super.printStackTrace();
        if(getNextException() != null) {
            getNextException().printStackTrace();
        }
    }

    /**
     * INTERNAL
     */
    public void printStackTrace(PrintWriter s) {
        if(s!=null) {
            super.printStackTrace(s);
            if(getNextException() != null) {
                getNextException().printStackTrace(s);
            }
        }
    }

    /**
     * INTERNAL
     */
    public void printStackTrace(PrintStream s) {
        if(s!=null) {        
            super.printStackTrace(s);
            if(getNextException() != null) {
                getNextException().printStackTrace(s);
            }
        }
    }

}
