/*
 * Copyright 2004-2006 H2 Group. Licensed under the H2 License, Version 1.0 (http://h2database.com/html/license.html).
 * Initial Developer: H2 Group
 */
package org.h2.command.ddl;

import java.sql.SQLException;

import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObject;
import org.h2.table.Table;
import org.h2.util.ObjectArray;

public class DropDatabase extends DefineCommand {
    
    private boolean dropAllObjects;
    private boolean deleteFiles;

    public DropDatabase(Session session) {
        super(session);
    }
    
    public int update() throws SQLException {
        if(dropAllObjects) {
            dropAllObjects();
        }
        if(deleteFiles) {
            session.getDatabase().setDeleteFilesOnDisconnect(true);
        }
        return 0;
    }
        
    private void dropAllObjects() throws SQLException {
        session.getUser().checkAdmin();
        session.commit();
        Database db = session.getDatabase();
        ObjectArray list;
        // TODO local temp tables are not removed
        list = db.getAllSchemas();
        for(int i=0; i<list.size(); i++) {
            Schema schema = (Schema) list.get(i);
            if(schema.canDrop()) {
                db.removeDatabaseObject(session, schema);
            }
        }
        list = db.getAllSchemaObjects(DbObject.TABLE_OR_VIEW);
        for(int i=0; i<list.size(); i++) {
            Table t = (Table) list.get(i);
            if(Table.VIEW.equals(t.getTableType())) {
                db.removeSchemaObject(session, t);
            }
        }
        for(int i=0; i<list.size(); i++) {
            Table t = (Table) list.get(i);
            if(Table.TABLE_LINK.equals(t.getTableType())) {
                db.removeSchemaObject(session, t);
            }
        }
        for(int i=0; i<list.size(); i++) {
            Table t = (Table) list.get(i);
            if(Table.TABLE.equals(t.getTableType())) {
                db.removeSchemaObject(session, t);
            }
        }
        list = db.getAllSchemaObjects(DbObject.SEQUENCE);
        // maybe constraints and triggers on system tables will be allowed in the future
        list.addAll(db.getAllSchemaObjects(DbObject.CONSTRAINT));
        list.addAll(db.getAllSchemaObjects(DbObject.TRIGGER));
        for(int i=0; i<list.size(); i++) {
            SchemaObject obj = (SchemaObject) list.get(i);
            db.removeSchemaObject(session, obj);
        }
        list = db.getAllUsers();
        for(int i=0; i<list.size(); i++) {
            User user = (User) list.get(i);
            if(user != session.getUser()) {
                db.removeDatabaseObject(session, user);
            }
        }
        list = db.getAllRoles();
        list.addAll(db.getAllRights());
        list.addAll(db.getAllFunctionAliases());
        for(int i=0; i<list.size(); i++) {
            DbObject obj = (DbObject) list.get(i);
            db.removeDatabaseObject(session, obj);
        }
    }

    public void setDropAllObjects(boolean b) {
        this.dropAllObjects = b;
    }
    
    public void setDeleteFiles(boolean b) {
        this.deleteFiles = b;
    }    
    
}
