/*
 * Decompiled with CFR 0.152.
 */
package ognl;

import [Ljava.lang.Object;;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ognl.ArrayElementsAccessor;
import ognl.ArrayPropertyAccessor;
import ognl.ClassResolver;
import ognl.CollectionElementsAccessor;
import ognl.ElementsAccessor;
import ognl.EnumerationElementsAccessor;
import ognl.EnumerationPropertyAccessor;
import ognl.EvaluationPool;
import ognl.IteratorElementsAccessor;
import ognl.IteratorPropertyAccessor;
import ognl.ListPropertyAccessor;
import ognl.MapElementsAccessor;
import ognl.MapPropertyAccessor;
import ognl.MethodAccessor;
import ognl.MethodFailedException;
import ognl.NoSuchPropertyException;
import ognl.NullHandler;
import ognl.NumberElementsAccessor;
import ognl.ObjectArrayPool;
import ognl.ObjectElementsAccessor;
import ognl.ObjectIndexedPropertyDescriptor;
import ognl.ObjectMethodAccessor;
import ognl.ObjectNullHandler;
import ognl.ObjectPropertyAccessor;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlInvokePermission;
import ognl.PropertyAccessor;
import ognl.SetPropertyAccessor;
import ognl.TypeConverter;

public abstract class OgnlRuntime {
    public static final Object NotFound = new Object();
    public static final List NotFoundList = new ArrayList();
    public static final Map NotFoundMap = new HashMap();
    public static final Object[] NoArguments = new Object[0];
    public static final Class[] NoArgumentTypes = new Class[0];
    public static final Object NoConversionPossible = "ognl.NoConversionPossible";
    public static int INDEXED_PROPERTY_NONE = 0;
    public static int INDEXED_PROPERTY_INT = 1;
    public static int INDEXED_PROPERTY_OBJECT = 2;
    public static final String NULL_STRING = "" + null;
    private static final String SET_PREFIX = "set";
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";
    private static final Map HEX_PADDING = new HashMap();
    private static final String HEX_PREFIX = "0x";
    private static final int HEX_LENGTH = 8;
    private static final String NULL_OBJECT_STRING = "<null>";
    private static ClassCache methodAccessors = new ClassCache();
    private static ClassCache propertyAccessors = new ClassCache();
    private static ClassCache elementsAccessors = new ClassCache();
    private static ClassCache nullHandlers = new ClassCache();
    private static ClassCache propertyDescriptorCache = new ClassCache();
    private static ClassCache constructorCache = new ClassCache();
    private static ClassCache staticMethodCache = new ClassCache();
    private static ClassCache instanceMethodCache = new ClassCache();
    private static ClassCache invokePermissionCache = new ClassCache();
    private static ClassCache fieldCache = new ClassCache();
    private static List superclasses = new ArrayList();
    private static ClassCache[] declaredMethods = new ClassCache[]{new ClassCache(), new ClassCache()};
    private static Map primitiveTypes = new HashMap(101);
    private static ClassCache primitiveDefaults = new ClassCache();
    private static Map methodParameterTypesCache = new HashMap(101);
    private static Map ctorParameterTypesCache = new HashMap(101);
    private static SecurityManager securityManager = System.getSecurityManager();
    private static EvaluationPool evaluationPool = new EvaluationPool();
    private static ObjectArrayPool objectArrayPool = new ObjectArrayPool();

    public static Class getTargetClass(Object o) {
        return o == null ? null : (o instanceof Class ? (Class<?>)o : o.getClass());
    }

    public static String getBaseName(Object o) {
        return o == null ? null : OgnlRuntime.getClassBaseName(o.getClass());
    }

    public static String getClassBaseName(Class c) {
        String s = c.getName();
        return s.substring(s.lastIndexOf(46) + 1);
    }

    public static String getClassName(Object o, boolean fullyQualified) {
        if (!(o instanceof Class)) {
            o = o.getClass();
        }
        return OgnlRuntime.getClassName(o, fullyQualified);
    }

    public static String getClassName(Class c, boolean fullyQualified) {
        return fullyQualified ? c.getName() : OgnlRuntime.getClassBaseName(c);
    }

    public static String getPackageName(Object o) {
        return o == null ? null : OgnlRuntime.getClassPackageName(o.getClass());
    }

    public static String getClassPackageName(Class c) {
        String s = c.getName();
        int i = s.lastIndexOf(46);
        return i < 0 ? null : s.substring(0, i);
    }

    public static String getPointerString(int num) {
        StringBuffer result = new StringBuffer();
        String hex = Integer.toHexString(num);
        Integer l = new Integer(hex.length());
        String pad = (String)HEX_PADDING.get(l);
        if (pad == null) {
            StringBuffer pb = new StringBuffer();
            for (int i = hex.length(); i < 8; ++i) {
                pb.append('0');
            }
            pad = new String(pb);
            HEX_PADDING.put(l, pad);
        }
        result.append(pad);
        result.append(hex);
        return new String(result);
    }

    public static String getPointerString(Object o) {
        return OgnlRuntime.getPointerString(o == null ? 0 : System.identityHashCode(o));
    }

    public static String getUniqueDescriptor(Object object, boolean fullyQualified) {
        StringBuffer result = new StringBuffer();
        if (object != null) {
            if (object instanceof Proxy) {
                Class<?> interfaceClass = object.getClass().getInterfaces()[0];
                result.append(OgnlRuntime.getClassName(interfaceClass, fullyQualified));
                result.append('^');
                object = Proxy.getInvocationHandler(object);
            }
            result.append(OgnlRuntime.getClassName(object, fullyQualified));
            result.append('@');
            result.append(OgnlRuntime.getPointerString(object));
        } else {
            result.append(NULL_OBJECT_STRING);
        }
        return new String(result);
    }

    public static String getUniqueDescriptor(Object object) {
        return OgnlRuntime.getUniqueDescriptor(object, false);
    }

    public static Object[] toArray(List list) {
        Object[] result;
        int size = list.size();
        if (size == 0) {
            result = NoArguments;
        } else {
            result = OgnlRuntime.getObjectArrayPool().create(list.size());
            for (int i = 0; i < size; ++i) {
                result[i] = list.get(i);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class[] getParameterTypes(Method m) {
        Map map = methodParameterTypesCache;
        synchronized (map) {
            Class[] result = (Class[])methodParameterTypesCache.get(m);
            if (result == null) {
                result = m.getParameterTypes();
                methodParameterTypesCache.put(m, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class[] getParameterTypes(Constructor c) {
        Map map = ctorParameterTypesCache;
        synchronized (map) {
            Class[] result = (Class[])ctorParameterTypesCache.get(c);
            if (result == null) {
                result = c.getParameterTypes();
                ctorParameterTypesCache.put(c, result);
            }
            return result;
        }
    }

    public static SecurityManager getSecurityManager() {
        return securityManager;
    }

    public static void setSecurityManager(SecurityManager value) {
        securityManager = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Permission getPermission(Method method) {
        Permission result = null;
        Class<?> mc = method.getDeclaringClass();
        ClassCache classCache = invokePermissionCache;
        synchronized (classCache) {
            HashMap<String, Permission> permissions = (HashMap<String, Permission>)invokePermissionCache.get(mc);
            if (permissions == null) {
                permissions = new HashMap<String, Permission>(101);
                invokePermissionCache.put(mc, permissions);
            }
            if ((result = (Permission)permissions.get(method.getName())) == null) {
                result = new OgnlInvokePermission("invoke." + mc.getName() + "." + method.getName());
                permissions.put(method.getName(), result);
            }
        }
        return result;
    }

    public static Object invokeMethod(Object target, Method method, Object[] argsArray) throws InvocationTargetException, IllegalAccessException {
        boolean wasAccessible = true;
        if (securityManager != null) {
            try {
                securityManager.checkPermission(OgnlRuntime.getPermission(method));
            }
            catch (SecurityException ex) {
                throw new IllegalAccessException("Method [" + method + "] cannot be accessed.");
            }
        }
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || (wasAccessible = method.isAccessible()))) {
            ((AccessibleObject)method).setAccessible(true);
        }
        Object result = method.invoke(target, argsArray);
        if (!wasAccessible) {
            ((AccessibleObject)method).setAccessible(false);
        }
        return result;
    }

    public static final Class getArgClass(Object arg) {
        if (arg == null) {
            return null;
        }
        Class<?> c = arg.getClass();
        if (c == Boolean.class) {
            return Boolean.TYPE;
        }
        if (c.getSuperclass() == Number.class) {
            if (c == Integer.class) {
                return Integer.TYPE;
            }
            if (c == Double.class) {
                return Double.TYPE;
            }
            if (c == Byte.class) {
                return Byte.TYPE;
            }
            if (c == Long.class) {
                return Long.TYPE;
            }
            if (c == Float.class) {
                return Float.TYPE;
            }
            if (c == Short.class) {
                return Short.TYPE;
            }
        } else if (c == Character.class) {
            return Character.TYPE;
        }
        return c;
    }

    public static final boolean isTypeCompatible(Object object, Class c) {
        boolean result = true;
        if (object != null) {
            if (c.isPrimitive()) {
                if (OgnlRuntime.getArgClass(object) != c) {
                    result = false;
                }
            } else if (!c.isInstance(object)) {
                result = false;
            }
        }
        return result;
    }

    public static final boolean areArgsCompatible(Object[] args, Class[] classes) {
        boolean result = true;
        if (args.length != classes.length) {
            result = false;
        } else {
            int count = args.length;
            for (int index = 0; result && index < count; ++index) {
                result = OgnlRuntime.isTypeCompatible(args[index], classes[index]);
            }
        }
        return result;
    }

    public static final boolean isMoreSpecific(Class[] classes1, Class[] classes2) {
        int count = classes1.length;
        for (int index = 0; index < count; ++index) {
            Class c1 = classes1[index];
            Class c2 = classes2[index];
            if (c1 == c2) continue;
            if (c1.isPrimitive()) {
                return true;
            }
            if (c1.isAssignableFrom(c2)) {
                return false;
            }
            if (!c2.isAssignableFrom(c1)) continue;
            return true;
        }
        return false;
    }

    public static final String getModifierString(int modifiers) {
        String result = Modifier.isPublic(modifiers) ? "public" : (Modifier.isProtected(modifiers) ? "protected" : (Modifier.isPrivate(modifiers) ? "private" : ""));
        if (Modifier.isStatic(modifiers)) {
            result = "static " + result;
        }
        if (Modifier.isFinal(modifiers)) {
            result = "final " + result;
        }
        if (Modifier.isNative(modifiers)) {
            result = "native " + result;
        }
        if (Modifier.isSynchronized(modifiers)) {
            result = "synchronized " + result;
        }
        if (Modifier.isTransient(modifiers)) {
            result = "transient " + result;
        }
        return result;
    }

    public static final Class classForName(OgnlContext context, String className) throws ClassNotFoundException {
        Class result = (Class)primitiveTypes.get(className);
        if (result == null) {
            ClassResolver resolver;
            if (context == null || (resolver = context.getClassResolver()) == null) {
                resolver = OgnlContext.DEFAULT_CLASS_RESOLVER;
            }
            result = resolver.classForName(className, context);
        }
        return result;
    }

    public static final boolean isInstance(OgnlContext context, Object value, String className) throws OgnlException {
        try {
            Class c = OgnlRuntime.classForName(context, className);
            return c.isInstance(value);
        }
        catch (ClassNotFoundException e) {
            throw new OgnlException("No such class: " + className, e);
        }
    }

    public static Object getPrimitiveDefaultValue(Class forClass) {
        return primitiveDefaults.get(forClass);
    }

    public static Object getConvertedType(OgnlContext context, Object target, Member member, String propertyName, Object value, Class type) {
        return context.getTypeConverter().convertValue(context, target, member, propertyName, value, type);
    }

    public static boolean getConvertedTypes(OgnlContext context, Object target, Member member, String propertyName, Class[] parameterTypes, Object[] args, Object[] newArgs) {
        boolean result = false;
        if (parameterTypes.length == args.length) {
            result = true;
            int ilast = parameterTypes.length - 1;
            for (int i = 0; result && i <= ilast; ++i) {
                Object arg = args[i];
                Class type = parameterTypes[i];
                if (OgnlRuntime.isTypeCompatible(arg, type)) {
                    newArgs[i] = arg;
                    continue;
                }
                Object v = OgnlRuntime.getConvertedType(context, target, member, propertyName, arg, type);
                if (v == NoConversionPossible) {
                    result = false;
                    continue;
                }
                newArgs[i] = v;
            }
        }
        return result;
    }

    public static Method getConvertedMethodAndArgs(OgnlContext context, Object target, String propertyName, List methods, Object[] args, Object[] newArgs) {
        Method result = null;
        TypeConverter converter = context.getTypeConverter();
        if (converter != null && methods != null) {
            int icount = methods.size();
            for (int i = 0; result == null && i < icount; ++i) {
                Class[] parameterTypes;
                Method m = (Method)methods.get(i);
                if (!OgnlRuntime.getConvertedTypes(context, target, m, propertyName, parameterTypes = OgnlRuntime.getParameterTypes(m), args, newArgs)) continue;
                result = m;
            }
        }
        return result;
    }

    public static Constructor getConvertedConstructorAndArgs(OgnlContext context, Object target, List constructors, Object[] args, Object[] newArgs) {
        Constructor result = null;
        TypeConverter converter = context.getTypeConverter();
        if (converter != null && constructors != null) {
            int icount = constructors.size();
            for (int i = 0; result == null && i < icount; ++i) {
                Class[] parameterTypes;
                Constructor ctor = (Constructor)constructors.get(i);
                if (!OgnlRuntime.getConvertedTypes(context, target, ctor, null, parameterTypes = OgnlRuntime.getParameterTypes(ctor), args, newArgs)) continue;
                result = ctor;
            }
        }
        return result;
    }

    public static Method getAppropriateMethod(OgnlContext context, Object source, Object target, String methodName, String propertyName, List methods, Object[] args, Object[] actualArgs) {
        Method result = null;
        Class[] resultParameterTypes = null;
        if (methods != null) {
            int icount = methods.size();
            for (int i = 0; i < icount; ++i) {
                Method m = (Method)methods.get(i);
                Class[] mParameterTypes = OgnlRuntime.getParameterTypes(m);
                if (!OgnlRuntime.areArgsCompatible(args, mParameterTypes) || result != null && !OgnlRuntime.isMoreSpecific(mParameterTypes, resultParameterTypes)) continue;
                result = m;
                resultParameterTypes = mParameterTypes;
                System.arraycopy(args, 0, actualArgs, 0, args.length);
                for (int j = 0; j < mParameterTypes.length; ++j) {
                    Class type = mParameterTypes[j];
                    if (!type.isPrimitive() || actualArgs[j] != null) continue;
                    actualArgs[j] = OgnlRuntime.getConvertedType(context, source, result, propertyName, null, type);
                }
            }
        }
        if (result == null) {
            result = OgnlRuntime.getConvertedMethodAndArgs(context, target, propertyName, methods, args, actualArgs);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object callAppropriateMethod(OgnlContext context, Object source, Object target, String methodName, String propertyName, List methods, Object[] args) throws MethodFailedException {
        Throwable reason = null;
        Object[] actualArgs = objectArrayPool.create(args.length);
        try {
            Method method = OgnlRuntime.getAppropriateMethod(context, source, target, methodName, propertyName, methods, args, actualArgs);
            if (method == null || !OgnlRuntime.isMethodAccessible(context, source, method, propertyName)) {
                StringBuffer buffer = new StringBuffer();
                if (args != null) {
                    int ilast = args.length - 1;
                    for (int i = 0; i <= ilast; ++i) {
                        Object arg = args[i];
                        buffer.append(arg == null ? NULL_STRING : arg.getClass().getName());
                        if (i >= ilast) continue;
                        buffer.append(", ");
                    }
                }
                throw new NoSuchMethodException(methodName + "(" + buffer + ")");
            }
            Object object = OgnlRuntime.invokeMethod(target, method, actualArgs);
            return object;
        }
        catch (NoSuchMethodException e) {
            reason = e;
        }
        catch (IllegalAccessException e) {
            reason = e;
        }
        catch (InvocationTargetException e) {
            reason = e.getTargetException();
        }
        finally {
            objectArrayPool.recycle(actualArgs);
        }
        throw new MethodFailedException(source, methodName, reason);
    }

    public static final Object callStaticMethod(OgnlContext context, String className, String methodName, Object[] args) throws OgnlException, MethodFailedException {
        try {
            Class targetClass = OgnlRuntime.classForName(context, className);
            MethodAccessor ma = OgnlRuntime.getMethodAccessor(targetClass);
            return ma.callStaticMethod(context, targetClass, methodName, args);
        }
        catch (ClassNotFoundException ex) {
            throw new MethodFailedException(className, methodName, ex);
        }
    }

    public static final Object callMethod(OgnlContext context, Object target, String methodName, String propertyName, Object[] args) throws OgnlException, MethodFailedException {
        if (target == null) {
            throw new NullPointerException("target is null for method " + methodName);
        }
        MethodAccessor ma = OgnlRuntime.getMethodAccessor(target.getClass());
        Object result = ma.callMethod(context, target, methodName, args);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object callConstructor(OgnlContext context, String className, Object[] args) throws OgnlException {
        Throwable reason = null;
        Object[] actualArgs = args;
        try {
            Constructor ctor = null;
            Class[] ctorParameterTypes = null;
            Class target = OgnlRuntime.classForName(context, className);
            List constructors = OgnlRuntime.getConstructors(target);
            int icount = constructors.size();
            for (int i = 0; i < icount; ++i) {
                Constructor c = (Constructor)constructors.get(i);
                Class[] cParameterTypes = OgnlRuntime.getParameterTypes(c);
                if (!OgnlRuntime.areArgsCompatible(args, cParameterTypes) || ctor != null && !OgnlRuntime.isMoreSpecific(cParameterTypes, ctorParameterTypes)) continue;
                ctor = c;
                ctorParameterTypes = cParameterTypes;
            }
            if (ctor == null && (ctor = OgnlRuntime.getConvertedConstructorAndArgs(context, target, constructors, args, actualArgs = objectArrayPool.create(args.length))) == null) {
                throw new NoSuchMethodException();
            }
            if (!context.getMemberAccess().isAccessible(context, target, ctor, null)) {
                throw new IllegalAccessException("access denied to " + target.getName() + "()");
            }
            Object t = ctor.newInstance(actualArgs);
            return t;
        }
        catch (ClassNotFoundException e) {
            reason = e;
        }
        catch (NoSuchMethodException e) {
            reason = e;
        }
        catch (IllegalAccessException e) {
            reason = e;
        }
        catch (InvocationTargetException e) {
            reason = e.getTargetException();
        }
        catch (InstantiationException e) {
            reason = e;
        }
        finally {
            if (actualArgs != args) {
                objectArrayPool.recycle(actualArgs);
            }
        }
        throw new MethodFailedException(className, "new", reason);
    }

    public static final Object getMethodValue(OgnlContext context, Object target, String propertyName) throws OgnlException, IllegalAccessException, NoSuchMethodException, IntrospectionException {
        return OgnlRuntime.getMethodValue(context, target, propertyName, false);
    }

    public static final Object getMethodValue(OgnlContext context, Object target, String propertyName, boolean checkAccessAndExistence) throws OgnlException, IllegalAccessException, NoSuchMethodException, IntrospectionException {
        Object result = null;
        Method m = OgnlRuntime.getGetMethod(context, target == null ? null : target.getClass(), propertyName);
        if (checkAccessAndExistence && (m == null || !context.getMemberAccess().isAccessible(context, target, m, propertyName))) {
            result = NotFound;
        }
        if (result == null) {
            if (m != null) {
                try {
                    result = OgnlRuntime.invokeMethod(target, m, NoArguments);
                }
                catch (InvocationTargetException ex) {
                    throw new OgnlException(propertyName, ex.getTargetException());
                }
            } else {
                throw new NoSuchMethodException(propertyName);
            }
        }
        return result;
    }

    public static final boolean setMethodValue(OgnlContext context, Object target, String propertyName, Object value) throws OgnlException, IllegalAccessException, NoSuchMethodException, MethodFailedException, IntrospectionException {
        return OgnlRuntime.setMethodValue(context, target, propertyName, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean setMethodValue(OgnlContext context, Object target, String propertyName, Object value, boolean checkAccessAndExistence) throws OgnlException, IllegalAccessException, NoSuchMethodException, MethodFailedException, IntrospectionException {
        boolean result = true;
        Method m = OgnlRuntime.getSetMethod(context, target == null ? null : target.getClass(), propertyName);
        if (checkAccessAndExistence && (m == null || !context.getMemberAccess().isAccessible(context, target, m, propertyName))) {
            result = false;
        }
        if (result) {
            if (m != null) {
                Object[] args = objectArrayPool.create(value);
                try {
                    OgnlRuntime.callAppropriateMethod(context, target, target, m.getName(), propertyName, Collections.nCopies(1, m), args);
                }
                finally {
                    objectArrayPool.recycle(args);
                }
            } else {
                result = false;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List getConstructors(Class targetClass) {
        List<Constructor<?>> result;
        ClassCache classCache = constructorCache;
        synchronized (classCache) {
            result = (List<Constructor<?>>)constructorCache.get(targetClass);
            if (result == null) {
                result = Arrays.asList(targetClass.getConstructors());
                constructorCache.put(targetClass, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Map getMethods(Class targetClass, boolean staticMethods) {
        HashMap<String, ArrayList<Method>> result;
        ClassCache cache;
        ClassCache classCache = cache = staticMethods ? staticMethodCache : instanceMethodCache;
        synchronized (classCache) {
            result = (HashMap<String, ArrayList<Method>>)cache.get(targetClass);
            if (result == null) {
                result = new HashMap<String, ArrayList<Method>>(23);
                cache.put(targetClass, result);
                for (Class c = targetClass; c != null; c = c.getSuperclass()) {
                    Method[] ma = c.getDeclaredMethods();
                    int icount = ma.length;
                    for (int i = 0; i < icount; ++i) {
                        if (Modifier.isStatic(ma[i].getModifiers()) != staticMethods) continue;
                        ArrayList<Method> ml = (ArrayList<Method>)result.get(ma[i].getName());
                        if (ml == null) {
                            ml = new ArrayList<Method>();
                            result.put(ma[i].getName(), ml);
                        }
                        ml.add(ma[i]);
                    }
                }
            }
        }
        return result;
    }

    public static final List getMethods(Class targetClass, String name, boolean staticMethods) {
        return (List)OgnlRuntime.getMethods(targetClass, staticMethods).get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Map getFields(Class targetClass) {
        HashMap<String, Field> result;
        ClassCache classCache = fieldCache;
        synchronized (classCache) {
            result = (HashMap<String, Field>)fieldCache.get(targetClass);
            if (result == null) {
                result = new HashMap<String, Field>(23);
                Field[] fa = targetClass.getDeclaredFields();
                for (int i = 0; i < fa.length; ++i) {
                    result.put(fa[i].getName(), fa[i]);
                }
                fieldCache.put(targetClass, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Field getField(Class inClass, String name) {
        Field result = null;
        ClassCache classCache = fieldCache;
        synchronized (classCache) {
            Object o = OgnlRuntime.getFields(inClass).get(name);
            if (o == null) {
                superclasses.clear();
                for (Class sc = inClass; sc != null && result == null && (o = OgnlRuntime.getFields(sc).get(name)) != NotFound; sc = sc.getSuperclass()) {
                    superclasses.add(sc);
                    result = (Field)o;
                    if (result != null) break;
                }
                int icount = superclasses.size();
                for (int i = 0; i < icount; ++i) {
                    OgnlRuntime.getFields((Class)superclasses.get(i)).put(name, result == null ? NotFound : result);
                }
            } else if (o instanceof Field) {
                result = (Field)o;
            } else if (result == NotFound) {
                result = null;
            }
        }
        return result;
    }

    public static final Object getFieldValue(OgnlContext context, Object target, String propertyName) throws NoSuchFieldException {
        return OgnlRuntime.getFieldValue(context, target, propertyName, false);
    }

    public static final Object getFieldValue(OgnlContext context, Object target, String propertyName, boolean checkAccessAndExistence) throws NoSuchFieldException {
        Object result = null;
        Field f = OgnlRuntime.getField(target == null ? null : target.getClass(), propertyName);
        if (checkAccessAndExistence && (f == null || !context.getMemberAccess().isAccessible(context, target, f, propertyName))) {
            result = NotFound;
        }
        if (result == null) {
            if (f == null) {
                throw new NoSuchFieldException(propertyName);
            }
            try {
                Object state = null;
                if (f == null || Modifier.isStatic(f.getModifiers())) {
                    throw new NoSuchFieldException(propertyName);
                }
                state = context.getMemberAccess().setup(context, target, f, propertyName);
                result = f.get(target);
                context.getMemberAccess().restore(context, target, f, propertyName, state);
            }
            catch (IllegalAccessException ex) {
                throw new NoSuchFieldException(propertyName);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean setFieldValue(OgnlContext context, Object target, String propertyName, Object value) throws OgnlException {
        boolean result;
        block6: {
            result = false;
            try {
                Field f = OgnlRuntime.getField(target == null ? null : target.getClass(), propertyName);
                if (f == null || Modifier.isStatic(f.getModifiers())) break block6;
                Object state = context.getMemberAccess().setup(context, target, f, propertyName);
                try {
                    if (OgnlRuntime.isTypeCompatible(value, f.getType()) || (value = OgnlRuntime.getConvertedType(context, target, f, propertyName, value, f.getType())) != null) {
                        f.set(target, value);
                        result = true;
                    }
                }
                finally {
                    context.getMemberAccess().restore(context, target, f, propertyName, state);
                }
            }
            catch (IllegalAccessException ex) {
                throw new NoSuchPropertyException(target, propertyName, ex);
            }
        }
        return result;
    }

    public static final boolean isFieldAccessible(OgnlContext context, Object target, Class inClass, String propertyName) {
        return OgnlRuntime.isFieldAccessible(context, target, OgnlRuntime.getField(inClass, propertyName), propertyName);
    }

    public static final boolean isFieldAccessible(OgnlContext context, Object target, Field field, String propertyName) {
        return context.getMemberAccess().isAccessible(context, target, field, propertyName);
    }

    public static final boolean hasField(OgnlContext context, Object target, Class inClass, String propertyName) {
        Field f = OgnlRuntime.getField(inClass, propertyName);
        return f != null && OgnlRuntime.isFieldAccessible(context, target, f, propertyName);
    }

    public static final Object getStaticField(OgnlContext context, String className, String fieldName) throws OgnlException {
        Exception reason = null;
        try {
            Class c = OgnlRuntime.classForName(context, className);
            if (fieldName.equals("class")) {
                return c;
            }
            Field f = c.getField(fieldName);
            if (!Modifier.isStatic(f.getModifiers())) {
                throw new OgnlException("Field " + fieldName + " of class " + className + " is not static");
            }
            return f.get(null);
        }
        catch (ClassNotFoundException e) {
            reason = e;
        }
        catch (NoSuchFieldException e) {
            reason = e;
        }
        catch (SecurityException e) {
            reason = e;
        }
        catch (IllegalAccessException e) {
            reason = e;
        }
        throw new OgnlException("Could not get static field " + fieldName + " from class " + className, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List getDeclaredMethods(Class targetClass, String propertyName, boolean findSets) {
        ClassCache cache;
        ArrayList<Method> result = null;
        ClassCache classCache = cache = declaredMethods[findSets ? 0 : 1];
        synchronized (classCache) {
            HashMap<String, List> propertyCache = (HashMap<String, List>)cache.get(targetClass);
            if (propertyCache == null || (result = (ArrayList<Method>)propertyCache.get(propertyName)) == null) {
                String baseName = Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
                int len = baseName.length();
                for (Class c = targetClass; c != null; c = c.getSuperclass()) {
                    Method[] methods = c.getDeclaredMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        int prefixLength;
                        String ms = methods[i].getName();
                        if (!ms.endsWith(baseName)) continue;
                        boolean isSet = false;
                        boolean isGet = false;
                        boolean isIs = false;
                        isSet = ms.startsWith(SET_PREFIX);
                        if (!isSet && !(isGet = ms.startsWith(GET_PREFIX)) && !(isIs = ms.startsWith(IS_PREFIX))) continue;
                        int n = prefixLength = isIs ? 2 : 3;
                        if (isSet != findSets || baseName.length() != ms.length() - prefixLength) continue;
                        if (result == null) {
                            result = new ArrayList<Method>();
                        }
                        result.add(methods[i]);
                    }
                }
                if (propertyCache == null) {
                    propertyCache = new HashMap<String, List>(101);
                    cache.put(targetClass, propertyCache);
                }
                propertyCache.put(propertyName, result == null ? NotFoundList : result);
            }
            return result == NotFoundList ? null : result;
        }
    }

    public static final Method getGetMethod(OgnlContext context, Class targetClass, String propertyName) throws IntrospectionException, OgnlException {
        Method result = null;
        PropertyDescriptor pd = OgnlRuntime.getPropertyDescriptor(targetClass, propertyName);
        if (pd == null) {
            List methods = OgnlRuntime.getDeclaredMethods(targetClass, propertyName, false);
            if (methods != null) {
                int icount = methods.size();
                for (int i = 0; i < icount; ++i) {
                    Method m = (Method)methods.get(i);
                    Class[] mParameterTypes = OgnlRuntime.getParameterTypes(m);
                    if (mParameterTypes.length != 0) continue;
                    result = m;
                    break;
                }
            }
        } else {
            result = pd.getReadMethod();
        }
        return result;
    }

    public static final boolean isMethodAccessible(OgnlContext context, Object target, Method method, String propertyName) {
        return method == null ? false : context.getMemberAccess().isAccessible(context, target, method, propertyName);
    }

    public static final boolean hasGetMethod(OgnlContext context, Object target, Class targetClass, String propertyName) throws IntrospectionException, OgnlException {
        return OgnlRuntime.isMethodAccessible(context, target, OgnlRuntime.getGetMethod(context, targetClass, propertyName), propertyName);
    }

    public static final Method getSetMethod(OgnlContext context, Class targetClass, String propertyName) throws IntrospectionException, OgnlException {
        Method result = null;
        PropertyDescriptor pd = OgnlRuntime.getPropertyDescriptor(targetClass, propertyName);
        if (pd == null) {
            List methods = OgnlRuntime.getDeclaredMethods(targetClass, propertyName, true);
            if (methods != null) {
                int icount = methods.size();
                for (int i = 0; i < icount; ++i) {
                    Method m = (Method)methods.get(i);
                    Class[] mParameterTypes = OgnlRuntime.getParameterTypes(m);
                    if (mParameterTypes.length != 1) continue;
                    result = m;
                    break;
                }
            }
        } else {
            result = pd.getWriteMethod();
        }
        return result;
    }

    public static final boolean hasSetMethod(OgnlContext context, Object target, Class targetClass, String propertyName) throws IntrospectionException, OgnlException {
        return OgnlRuntime.isMethodAccessible(context, target, OgnlRuntime.getSetMethod(context, targetClass, propertyName), propertyName);
    }

    public static final boolean hasGetProperty(OgnlContext context, Object target, Object oname) throws IntrospectionException, OgnlException {
        Class<?> targetClass = target == null ? null : target.getClass();
        String name = oname.toString();
        return OgnlRuntime.hasGetMethod(context, target, targetClass, name) || OgnlRuntime.hasField(context, target, targetClass, name);
    }

    public static final boolean hasSetProperty(OgnlContext context, Object target, Object oname) throws IntrospectionException, OgnlException {
        Class<?> targetClass = target == null ? null : target.getClass();
        String name = oname.toString();
        return OgnlRuntime.hasSetMethod(context, target, targetClass, name) || OgnlRuntime.hasField(context, target, targetClass, name);
    }

    private static final boolean indexMethodCheck(List methods) {
        boolean result = false;
        if (methods.size() > 0) {
            Method fm = (Method)methods.get(0);
            Class[] fmpt = OgnlRuntime.getParameterTypes(fm);
            int fmpc = fmpt.length;
            Class<?> lastMethodClass = fm.getDeclaringClass();
            result = true;
            for (int i = 1; result && i < methods.size(); ++i) {
                Method m = (Method)methods.get(i);
                Class<?> c = m.getDeclaringClass();
                if (lastMethodClass == c) {
                    result = false;
                } else {
                    Class[] mpt = OgnlRuntime.getParameterTypes(fm);
                    int mpc = fmpt.length;
                    if (fmpc != mpc) {
                        result = false;
                    }
                    for (int j = 0; j < fmpc; ++j) {
                        if (fmpt[j] == mpt[j]) continue;
                        result = false;
                        break;
                    }
                }
                lastMethodClass = c;
            }
        }
        return result;
    }

    private static final void findObjectIndexedPropertyDescriptors(Class targetClass, Map intoMap) throws OgnlException {
        List methods;
        Map allMethods = OgnlRuntime.getMethods(targetClass, false);
        HashMap pairs = new HashMap(101);
        Iterator it = allMethods.keySet().iterator();
        while (it.hasNext()) {
            List<Method> pair;
            String methodName = (String)it.next();
            methods = (List)allMethods.get(methodName);
            if (!OgnlRuntime.indexMethodCheck(methods)) continue;
            boolean isGet = false;
            boolean isSet = false;
            Method m = (Method)methods.get(0);
            isSet = methodName.startsWith(SET_PREFIX);
            if (!isSet && !(isGet = methodName.startsWith(GET_PREFIX)) || methodName.length() <= 3) continue;
            String propertyName = Introspector.decapitalize(methodName.substring(3));
            Class[] parameterTypes = OgnlRuntime.getParameterTypes(m);
            int parameterCount = parameterTypes.length;
            if (isGet && parameterCount == 1 && m.getReturnType() != Void.TYPE) {
                pair = (ArrayList<Method>)pairs.get(propertyName);
                if (pair == null) {
                    pair = new ArrayList<Method>();
                    pairs.put(propertyName, pair);
                }
                pair.add(m);
            }
            if (!isSet || parameterCount != 2 || m.getReturnType() != Void.TYPE) continue;
            pair = (List)pairs.get(propertyName);
            if (pair == null) {
                pair = new ArrayList();
                pairs.put(propertyName, pair);
            }
            pair.add(m);
        }
        it = pairs.keySet().iterator();
        while (it.hasNext()) {
            ObjectIndexedPropertyDescriptor propertyDescriptor;
            String propertyName = (String)it.next();
            methods = (List)pairs.get(propertyName);
            if (methods.size() != 2) continue;
            Method method1 = (Method)methods.get(0);
            Method method2 = (Method)methods.get(1);
            Method setMethod = method1.getParameterTypes().length == 2 ? method1 : method2;
            Method getMethod = setMethod == method1 ? method2 : method1;
            Class<?> keyType = getMethod.getParameterTypes()[0];
            Class<?> propertyType = getMethod.getReturnType();
            if (keyType != setMethod.getParameterTypes()[0] || propertyType != setMethod.getParameterTypes()[1]) continue;
            try {
                propertyDescriptor = new ObjectIndexedPropertyDescriptor(propertyName, propertyType, getMethod, setMethod);
            }
            catch (Exception ex) {
                throw new OgnlException("creating object indexed property descriptor for '" + propertyName + "' in " + targetClass, ex);
            }
            intoMap.put(propertyName, propertyDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Map getPropertyDescriptors(Class targetClass) throws IntrospectionException, OgnlException {
        HashMap<String, PropertyDescriptor> result;
        ClassCache classCache = propertyDescriptorCache;
        synchronized (classCache) {
            result = (HashMap<String, PropertyDescriptor>)propertyDescriptorCache.get(targetClass);
            if (result == null) {
                PropertyDescriptor[] pda = Introspector.getBeanInfo(targetClass).getPropertyDescriptors();
                result = new HashMap<String, PropertyDescriptor>(101);
                int icount = pda.length;
                for (int i = 0; i < icount; ++i) {
                    result.put(pda[i].getName(), pda[i]);
                }
                OgnlRuntime.findObjectIndexedPropertyDescriptors(targetClass, result);
                propertyDescriptorCache.put(targetClass, result);
            }
        }
        return result;
    }

    public static final PropertyDescriptor getPropertyDescriptor(Class targetClass, String propertyName) throws IntrospectionException, OgnlException {
        return targetClass == null ? null : (PropertyDescriptor)OgnlRuntime.getPropertyDescriptors(targetClass).get(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final PropertyDescriptor[] getPropertyDescriptorsArray(Class targetClass) throws IntrospectionException {
        PropertyDescriptor[] result = null;
        if (targetClass != null) {
            ClassCache classCache = propertyDescriptorCache;
            synchronized (classCache) {
                result = (PropertyDescriptor[])propertyDescriptorCache.get(targetClass);
                if (result == null) {
                    result = Introspector.getBeanInfo(targetClass).getPropertyDescriptors();
                    propertyDescriptorCache.put(targetClass, result);
                }
            }
        }
        return result;
    }

    public static final PropertyDescriptor getPropertyDescriptorFromArray(Class targetClass, String name) throws IntrospectionException {
        PropertyDescriptor result = null;
        PropertyDescriptor[] pda = OgnlRuntime.getPropertyDescriptorsArray(targetClass);
        int icount = pda.length;
        for (int i = 0; result == null && i < icount; ++i) {
            if (pda[i].getName().compareTo(name) != 0) continue;
            result = pda[i];
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setMethodAccessor(Class cls, MethodAccessor accessor) {
        ClassCache classCache = methodAccessors;
        synchronized (classCache) {
            methodAccessors.put(cls, accessor);
        }
    }

    public static final MethodAccessor getMethodAccessor(Class cls) throws OgnlException {
        MethodAccessor answer = (MethodAccessor)OgnlRuntime.getHandler(cls, methodAccessors);
        if (answer != null) {
            return answer;
        }
        throw new OgnlException("No method accessor for " + cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setPropertyAccessor(Class cls, PropertyAccessor accessor) {
        ClassCache classCache = propertyAccessors;
        synchronized (classCache) {
            propertyAccessors.put(cls, accessor);
        }
    }

    public static final PropertyAccessor getPropertyAccessor(Class cls) throws OgnlException {
        PropertyAccessor answer = (PropertyAccessor)OgnlRuntime.getHandler(cls, propertyAccessors);
        if (answer != null) {
            return answer;
        }
        throw new OgnlException("No property accessor for class " + cls);
    }

    public static final ElementsAccessor getElementsAccessor(Class cls) throws OgnlException {
        ElementsAccessor answer = (ElementsAccessor)OgnlRuntime.getHandler(cls, elementsAccessors);
        if (answer != null) {
            return answer;
        }
        throw new OgnlException("No elements accessor for class " + cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setElementsAccessor(Class cls, ElementsAccessor accessor) {
        ClassCache classCache = elementsAccessors;
        synchronized (classCache) {
            elementsAccessors.put(cls, accessor);
        }
    }

    public static final NullHandler getNullHandler(Class cls) throws OgnlException {
        NullHandler answer = (NullHandler)OgnlRuntime.getHandler(cls, nullHandlers);
        if (answer != null) {
            return answer;
        }
        throw new OgnlException("No null handler for class " + cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void setNullHandler(Class cls, NullHandler handler) {
        ClassCache classCache = nullHandlers;
        synchronized (classCache) {
            nullHandlers.put(cls, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object getHandler(Class forClass, ClassCache handlers) {
        Object answer = null;
        ClassCache classCache = handlers;
        synchronized (classCache) {
            answer = handlers.get(forClass);
            if (answer == null) {
                Class<Object> keyFound;
                if (forClass.isArray()) {
                    answer = handlers.get(Object;.class);
                    keyFound = null;
                } else {
                    keyFound = forClass;
                    block3: for (Class c = forClass; c != null; c = c.getSuperclass()) {
                        answer = handlers.get(c);
                        if (answer == null) {
                            Class<?>[] interfaces = c.getInterfaces();
                            int count = interfaces.length;
                            for (int index = 0; index < count; ++index) {
                                Class<?> iface = interfaces[index];
                                answer = handlers.get(iface);
                                if (answer == null) {
                                    answer = OgnlRuntime.getHandler(iface, handlers);
                                }
                                if (answer == null) continue;
                                keyFound = iface;
                                break block3;
                            }
                            continue;
                        }
                        keyFound = c;
                        break;
                    }
                }
                if (answer != null && keyFound != forClass) {
                    handlers.put(forClass, answer);
                }
            }
        }
        return answer;
    }

    public static final Object getProperty(OgnlContext context, Object source, Object name) throws OgnlException {
        if (source == null) {
            throw new OgnlException("source is null for getProperty(null, \"" + name + "\")");
        }
        PropertyAccessor accessor = OgnlRuntime.getPropertyAccessor(OgnlRuntime.getTargetClass(source));
        if (accessor == null) {
            throw new OgnlException("No property accessor for " + OgnlRuntime.getTargetClass(source).getName());
        }
        return accessor.getProperty(context, source, name);
    }

    public static final void setProperty(OgnlContext context, Object target, Object name, Object value) throws OgnlException {
        if (target == null) {
            throw new OgnlException("target is null for setProperty(null, \"" + name + "\", " + value + ")");
        }
        PropertyAccessor accessor = OgnlRuntime.getPropertyAccessor(OgnlRuntime.getTargetClass(target));
        if (accessor == null) {
            throw new OgnlException("No property accessor for " + OgnlRuntime.getTargetClass(target).getName());
        }
        accessor.setProperty(context, target, name, value);
    }

    public static final int getIndexedPropertyType(OgnlContext context, Class sourceClass, String name) throws OgnlException {
        int result = INDEXED_PROPERTY_NONE;
        try {
            PropertyDescriptor pd = OgnlRuntime.getPropertyDescriptor(sourceClass, name);
            if (pd != null) {
                if (pd instanceof IndexedPropertyDescriptor) {
                    result = INDEXED_PROPERTY_INT;
                } else if (pd instanceof ObjectIndexedPropertyDescriptor) {
                    result = INDEXED_PROPERTY_OBJECT;
                }
            }
        }
        catch (Exception ex) {
            throw new OgnlException("problem determining if '" + name + "' is an indexed property", ex);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static final Object getIndexedProperty(OgnlContext context, Object source, String name, Object index) throws OgnlException {
        Object reason = null;
        Object[] args = objectArrayPool.create(index);
        try {
            void var7_9;
            Method m;
            PropertyDescriptor pd = OgnlRuntime.getPropertyDescriptor(source == null ? null : source.getClass(), name);
            if (pd instanceof IndexedPropertyDescriptor) {
                m = ((IndexedPropertyDescriptor)pd).getIndexedReadMethod();
            } else if (pd instanceof ObjectIndexedPropertyDescriptor) {
                m = ((ObjectIndexedPropertyDescriptor)pd).getIndexedReadMethod();
            } else {
                throw new OgnlException("property '" + name + "' is not an indexed property");
            }
            Object object = OgnlRuntime.callMethod(context, source, var7_9.getName(), name, args);
            return object;
        }
        catch (OgnlException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OgnlException("getting indexed property descriptor for '" + name + "'", ex);
        }
        finally {
            objectArrayPool.recycle(args);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void setIndexedProperty(OgnlContext context, Object source, String name, Object index, Object value) throws OgnlException {
        Object reason = null;
        Object[] args = objectArrayPool.create(index, value);
        try {
            void var8_10;
            Method m;
            PropertyDescriptor pd = OgnlRuntime.getPropertyDescriptor(source == null ? null : source.getClass(), name);
            if (pd instanceof IndexedPropertyDescriptor) {
                m = ((IndexedPropertyDescriptor)pd).getIndexedWriteMethod();
            } else if (pd instanceof ObjectIndexedPropertyDescriptor) {
                m = ((ObjectIndexedPropertyDescriptor)pd).getIndexedWriteMethod();
            } else {
                throw new OgnlException("property '" + name + "' is not an indexed property");
            }
            OgnlRuntime.callMethod(context, source, var8_10.getName(), name, args);
        }
        catch (OgnlException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OgnlException("getting indexed property descriptor for '" + name + "'", ex);
        }
        finally {
            objectArrayPool.recycle(args);
        }
    }

    public static EvaluationPool getEvaluationPool() {
        return evaluationPool;
    }

    public static ObjectArrayPool getObjectArrayPool() {
        return objectArrayPool;
    }

    static {
        ArrayPropertyAccessor p = new ArrayPropertyAccessor();
        OgnlRuntime.setPropertyAccessor(Object.class, new ObjectPropertyAccessor());
        OgnlRuntime.setPropertyAccessor([B.class, p);
        OgnlRuntime.setPropertyAccessor([S.class, p);
        OgnlRuntime.setPropertyAccessor([C.class, p);
        OgnlRuntime.setPropertyAccessor([I.class, p);
        OgnlRuntime.setPropertyAccessor([J.class, p);
        OgnlRuntime.setPropertyAccessor([F.class, p);
        OgnlRuntime.setPropertyAccessor([D.class, p);
        OgnlRuntime.setPropertyAccessor(Object;.class, p);
        OgnlRuntime.setPropertyAccessor(List.class, new ListPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(Map.class, new MapPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(Set.class, new SetPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(Iterator.class, new IteratorPropertyAccessor());
        OgnlRuntime.setPropertyAccessor(Enumeration.class, new EnumerationPropertyAccessor());
        ArrayElementsAccessor e = new ArrayElementsAccessor();
        OgnlRuntime.setElementsAccessor(Object.class, new ObjectElementsAccessor());
        OgnlRuntime.setElementsAccessor([B.class, e);
        OgnlRuntime.setElementsAccessor([S.class, e);
        OgnlRuntime.setElementsAccessor([C.class, e);
        OgnlRuntime.setElementsAccessor([I.class, e);
        OgnlRuntime.setElementsAccessor([J.class, e);
        OgnlRuntime.setElementsAccessor([F.class, e);
        OgnlRuntime.setElementsAccessor([D.class, e);
        OgnlRuntime.setElementsAccessor(Object;.class, e);
        OgnlRuntime.setElementsAccessor(Collection.class, new CollectionElementsAccessor());
        OgnlRuntime.setElementsAccessor(Map.class, new MapElementsAccessor());
        OgnlRuntime.setElementsAccessor(Iterator.class, new IteratorElementsAccessor());
        OgnlRuntime.setElementsAccessor(Enumeration.class, new EnumerationElementsAccessor());
        OgnlRuntime.setElementsAccessor(Number.class, new NumberElementsAccessor());
        ObjectNullHandler nh = new ObjectNullHandler();
        OgnlRuntime.setNullHandler(Object.class, nh);
        OgnlRuntime.setNullHandler([B.class, nh);
        OgnlRuntime.setNullHandler([S.class, nh);
        OgnlRuntime.setNullHandler([C.class, nh);
        OgnlRuntime.setNullHandler([I.class, nh);
        OgnlRuntime.setNullHandler([J.class, nh);
        OgnlRuntime.setNullHandler([F.class, nh);
        OgnlRuntime.setNullHandler([D.class, nh);
        OgnlRuntime.setNullHandler(Object;.class, nh);
        ObjectMethodAccessor ma = new ObjectMethodAccessor();
        OgnlRuntime.setMethodAccessor(Object.class, ma);
        OgnlRuntime.setMethodAccessor([B.class, ma);
        OgnlRuntime.setMethodAccessor([S.class, ma);
        OgnlRuntime.setMethodAccessor([C.class, ma);
        OgnlRuntime.setMethodAccessor([I.class, ma);
        OgnlRuntime.setMethodAccessor([J.class, ma);
        OgnlRuntime.setMethodAccessor([F.class, ma);
        OgnlRuntime.setMethodAccessor([D.class, ma);
        OgnlRuntime.setMethodAccessor(Object;.class, ma);
        primitiveTypes.put("boolean", Boolean.TYPE);
        primitiveTypes.put("byte", Byte.TYPE);
        primitiveTypes.put("short", Short.TYPE);
        primitiveTypes.put("char", Character.TYPE);
        primitiveTypes.put("int", Integer.TYPE);
        primitiveTypes.put("long", Long.TYPE);
        primitiveTypes.put("float", Float.TYPE);
        primitiveTypes.put("double", Double.TYPE);
        primitiveDefaults.put(Boolean.TYPE, Boolean.FALSE);
        primitiveDefaults.put(Byte.TYPE, new Byte(0));
        primitiveDefaults.put(Short.TYPE, new Short(0));
        primitiveDefaults.put(Character.TYPE, new Character('\u0000'));
        primitiveDefaults.put(Integer.TYPE, new Integer(0));
        primitiveDefaults.put(Long.TYPE, new Long(0L));
        primitiveDefaults.put(Float.TYPE, new Float(0.0f));
        primitiveDefaults.put(Double.TYPE, new Double(0.0));
        primitiveDefaults.put(BigInteger.class, new BigInteger("0"));
        primitiveDefaults.put(BigDecimal.class, new BigDecimal(0.0));
    }

    private static class ClassCache {
        private static final int TABLE_SIZE = 512;
        private static final int TABLE_SIZE_MASK = 511;
        private Entry[] table = new Entry[512];

        public final Object get(Class key) {
            Object result = null;
            int i = key.hashCode() & 0x1FF;
            Entry entry = this.table[i];
            while (entry != null) {
                if (entry.key == key) {
                    result = entry.value;
                    break;
                }
                entry = entry.next;
            }
            return result;
        }

        public final Object put(Class key, Object value) {
            Object result = null;
            int i = key.hashCode() & 0x1FF;
            Entry entry = this.table[i];
            if (entry == null) {
                this.table[i] = new Entry(key, value);
            } else if (entry.key == key) {
                result = entry.value;
                entry.value = value;
            } else {
                while (true) {
                    if (entry.key == key) {
                        result = entry.value;
                        entry.value = value;
                        break;
                    }
                    if (entry.next == null) {
                        entry.next = new Entry(key, value);
                        break;
                    }
                    entry = entry.next;
                }
            }
            return result;
        }

        private static class Entry {
            protected Entry next;
            protected Class key;
            protected Object value;

            public Entry(Class key, Object value) {
                this.key = key;
                this.value = value;
            }
        }
    }
}

