/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.message.Message;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueDouble
extends Value {
    public static final int PRECISION = 17;
    private double value;
    private static final double DOUBLE_ZERO = 0.0;
    private static final double DOUBLE_ONE = 1.0;
    private static final ValueDouble ZERO = new ValueDouble(0.0);
    private static final ValueDouble ONE = new ValueDouble(1.0);

    private ValueDouble(double value) {
        this.value = value;
    }

    public Value add(Value v) {
        ValueDouble v2 = (ValueDouble)v;
        return ValueDouble.get(this.value + v2.value);
    }

    public Value subtract(Value v) {
        ValueDouble v2 = (ValueDouble)v;
        return ValueDouble.get(this.value - v2.value);
    }

    public Value negate() {
        return ValueDouble.get(-this.value);
    }

    public Value multiply(Value v) {
        ValueDouble v2 = (ValueDouble)v;
        return ValueDouble.get(this.value * v2.value);
    }

    public Value divide(Value v) throws SQLException {
        ValueDouble v2 = (ValueDouble)v;
        if (v2.value == 0.0) {
            throw Message.getSQLException(22012, this.getSQL());
        }
        return ValueDouble.get(this.value / v2.value);
    }

    public String getSQL() {
        return this.getString();
    }

    public int getType() {
        return 7;
    }

    protected int compareSecure(Value o, CompareMode mode) {
        ValueDouble v = (ValueDouble)o;
        if (this.value == v.value) {
            return 0;
        }
        return this.value > v.value ? 1 : -1;
    }

    public int getSignum() {
        return this.value == 0.0 ? 0 : (this.value < 0.0 ? -1 : 1);
    }

    public double getDouble() {
        return this.value;
    }

    public String getString() {
        return String.valueOf(this.value);
    }

    public long getPrecision() {
        return 17L;
    }

    public int getScale() {
        return 0;
    }

    public int hashCode() {
        long hash = Double.doubleToLongBits(this.value);
        return (int)(hash ^ hash >> 32);
    }

    public Object getObject() {
        return new Double(this.value);
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setDouble(parameterIndex, this.value);
    }

    public static ValueDouble get(double d) {
        if (0.0 == d) {
            return ZERO;
        }
        if (1.0 == d) {
            return ONE;
        }
        return (ValueDouble)Value.cache(new ValueDouble(d));
    }

    public int getDisplaySize() {
        return 19;
    }

    protected boolean isEqual(Value v) {
        return v instanceof ValueDouble && this.value == ((ValueDouble)v).value;
    }
}

