/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import java.text.Collator;
import org.h2.command.Prepared;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.expression.Expression;
import org.h2.expression.ValueExpression;
import org.h2.message.Message;
import org.h2.table.Table;
import org.h2.tools.CompressTool;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.ValueInt;

public class Set
extends Prepared {
    public static final int IGNORECASE = 1;
    public static final int MAX_LOG_SIZE = 2;
    public static final int MODE = 3;
    public static final int READONLY = 4;
    public static final int LOCK_TIMEOUT = 5;
    public static final int DEFAULT_LOCK_TIMEOUT = 6;
    public static final int DEFAULT_TABLE_TYPE = 7;
    public static final int CACHE_SIZE = 8;
    public static final int TRACE_LEVEL_SYSTEM_OUT = 9;
    public static final int TRACE_LEVEL_FILE = 10;
    public static final int TRACE_MAX_FILE_SIZE = 11;
    public static final int COLLATION = 12;
    public static final int CLUSTER = 13;
    public static final int WRITE_DELAY = 14;
    public static final int DATABASE_EVENT_LISTENER = 15;
    public static final int MAX_MEMORY_ROWS = 16;
    public static final int LOCK_MODE = 17;
    public static final int ASSERT = 18;
    public static final int DB_CLOSE_DELAY = 19;
    public static final int LOG = 20;
    public static final int THROTTLE = 21;
    public static final int MAX_MEMORY_UNDO = 22;
    public static final int MAX_LENGTH_INPLACE_LOB = 23;
    public static final int COMPRESS_LOB = 24;
    public static final int ALLOW_LITERALS = 25;
    public static final int MULTI_THREADED = 26;
    private int type;
    private Expression expression;
    private String stringValue;
    private static ObjectArray types = new ObjectArray();

    private static void setType(int type, String name) {
        while (types.size() <= type) {
            types.add(null);
        }
        types.set(type, name);
    }

    public static int getType(String name) {
        for (int i = 0; i < types.size(); ++i) {
            if (!name.equals(types.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static ObjectArray getSettings() {
        return types;
    }

    public static String getTypeName(int type) {
        return (String)types.get(type);
    }

    public Set(Session session, int type) {
        super(session);
        this.type = type;
    }

    public void setString(String v) {
        this.stringValue = v;
    }

    public boolean isTransactional() {
        return false;
    }

    public int update() throws SQLException {
        Database database = this.session.getDatabase();
        String name = Set.getTypeName(this.type);
        switch (this.type) {
            case 2: {
                this.session.getUser().checkAdmin();
                this.session.getDatabase().setMaxLogSize((long)this.getIntValue() * 1024L * 1024L);
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 5: {
                this.session.setLockTimeout(this.getIntValue());
                break;
            }
            case 17: {
                this.session.getUser().checkAdmin();
                database.setLockMode(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 6: {
                this.session.getUser().checkAdmin();
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 7: {
                this.session.getUser().checkAdmin();
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 9: {
                this.session.getUser().checkAdmin();
                database.getTraceSystem().setLevelSystemOut(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 10: {
                this.session.getUser().checkAdmin();
                database.getTraceSystem().setLevelFile(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 11: {
                this.session.getUser().checkAdmin();
                int size = this.getIntValue() * 1024 * 1024;
                database.getTraceSystem().setMaxFileSize(size);
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 8: {
                this.session.getUser().checkAdmin();
                database.setCacheSize(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 3: {
                this.session.getUser().checkAdmin();
                Mode mode = Mode.getMode(this.stringValue);
                if (mode == null) {
                    throw Message.getSQLException(90088, this.stringValue);
                }
                Mode.setCurrentMode(mode);
                break;
            }
            case 12: {
                CompareMode compareMode;
                this.session.getUser().checkAdmin();
                ObjectArray array = database.getAllSchemaObjects(0);
                for (int i = 0; i < array.size(); ++i) {
                    Table table = (Table)array.get(i);
                    if (table.getCreateSQL() == null) continue;
                    throw Message.getSQLException(90089, table.getSQL());
                }
                StringBuffer buff = new StringBuffer(this.stringValue);
                if (this.stringValue.equals("OFF")) {
                    compareMode = new CompareMode(null, null);
                } else {
                    Collator coll = CompareMode.getCollator(this.stringValue);
                    compareMode = new CompareMode(coll, this.stringValue);
                    buff.append(" STRENGTH ");
                    if (this.getIntValue() == 3) {
                        buff.append("IDENTICAL");
                    } else if (this.getIntValue() == 0) {
                        buff.append("PRIMARY");
                    } else if (this.getIntValue() == 1) {
                        buff.append("SECONDARY");
                    } else if (this.getIntValue() == 2) {
                        buff.append("TERTIARY");
                    }
                    coll.setStrength(this.getIntValue());
                }
                this.addOrUpdateSetting(name, buff.toString(), 0);
                database.setCompareMode(compareMode);
                break;
            }
            case 1: {
                this.session.getUser().checkAdmin();
                this.session.getDatabase().setIgnoreCase(this.getIntValue() == 1);
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 13: {
                this.session.getUser().checkAdmin();
                database.setCluster(StringUtils.quoteStringSQL(this.stringValue));
                this.addOrUpdateSetting(name, StringUtils.quoteStringSQL(this.stringValue), 0);
                break;
            }
            case 14: {
                this.session.getUser().checkAdmin();
                database.setWriteDelay(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 15: {
                this.session.getUser().checkAdmin();
                database.setEventListener(this.stringValue);
                break;
            }
            case 16: {
                this.session.getUser().checkAdmin();
                database.setMaxMemoryRows(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 18: {
                this.session.getUser().checkAdmin();
                Constants.CHECK = this.getIntValue() == 1;
                break;
            }
            case 26: {
                this.session.getUser().checkAdmin();
                Constants.MULTI_THREADED_KERNEL = this.getIntValue() == 1;
                break;
            }
            case 19: {
                this.session.getUser().checkAdmin();
                database.setCloseDelay(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 20: {
                int value = this.getIntValue();
                if (value < 0 || value > 2) {
                    throw Message.getInvalidValueException("" + this.getIntValue(), "LOG");
                }
                if (value == 0) {
                    this.session.getUser().checkAdmin();
                }
                database.setLog(value);
                break;
            }
            case 21: {
                if (this.getIntValue() < 0) {
                    throw Message.getInvalidValueException("" + this.getIntValue(), "THROTTLE");
                }
                this.session.setThrottle(this.getIntValue());
                break;
            }
            case 22: {
                if (this.getIntValue() < 0) {
                    throw Message.getInvalidValueException("" + this.getIntValue(), "MAX_MEMORY_UNDO");
                }
                this.session.getUser().checkAdmin();
                database.setMaxMemoryUndo(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 23: {
                if (this.getIntValue() < 0) {
                    throw Message.getInvalidValueException("" + this.getIntValue(), "MAX_LENGTH_INPLACE_LOB");
                }
                this.session.getUser().checkAdmin();
                database.setMaxLengthInplaceLob(this.getIntValue());
                this.addOrUpdateSetting(name, null, this.getIntValue());
                break;
            }
            case 24: {
                this.session.getUser().checkAdmin();
                int algo = CompressTool.getInstance().getCompressAlgorithm(this.stringValue);
                database.setLobCompressionAlgorithm(algo == 0 ? null : this.stringValue);
                this.addOrUpdateSetting(name, this.stringValue, 0);
                break;
            }
            case 25: {
                this.session.getUser().checkAdmin();
                int value = this.getIntValue();
                if (value < 0 || value > 2) {
                    throw Message.getInvalidValueException("" + this.getIntValue(), "ALLOW_LITERALS");
                }
                database.setAllowLiterals(value);
                this.addOrUpdateSetting(name, null, value);
                break;
            }
            default: {
                throw Message.internal("type=" + this.type);
            }
        }
        return 0;
    }

    private int getIntValue() throws SQLException {
        this.expression = this.expression.optimize(this.session);
        return this.expression.getValue(this.session).getInt();
    }

    public void setInt(int value) {
        this.expression = ValueExpression.get(ValueInt.get(value));
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    private void addOrUpdateSetting(String name, String s, int v) throws SQLException {
        Database database = this.session.getDatabase();
        if (database.getReadOnly()) {
            return;
        }
        Setting setting = database.findSetting(name);
        boolean addNew = false;
        if (setting == null) {
            addNew = true;
            int id = this.getObjectId(false, true);
            setting = new Setting(database, id, name);
        }
        if (s != null) {
            if (!addNew && setting.getStringValue().equals(s)) {
                return;
            }
            setting.setStringValue(s);
        } else {
            if (!addNew && setting.getIntValue() == v) {
                return;
            }
            setting.setIntValue(v);
        }
        if (addNew) {
            database.addDatabaseObject(this.session, setting);
        } else {
            database.update(this.session, setting);
        }
    }

    public boolean needRecompile() {
        return false;
    }

    static {
        Set.setType(1, "IGNORECASE");
        Set.setType(2, "MAX_LOG_SIZE");
        Set.setType(3, "MODE");
        Set.setType(4, "READONLY");
        Set.setType(5, "LOCK_TIMEOUT");
        Set.setType(6, "DEFAULT_LOCK_TIMEOUT");
        Set.setType(7, "DEFAULT_TABLE_TYPE");
        Set.setType(8, "CACHE_SIZE");
        Set.setType(9, "TRACE_LEVEL_SYSTEM_OUT");
        Set.setType(10, "TRACE_LEVEL_FILE");
        Set.setType(11, "TRACE_MAX_FILE_SIZE");
        Set.setType(12, "COLLATION");
        Set.setType(13, "CLUSTER");
        Set.setType(14, "WRITE_DELAY");
        Set.setType(15, "DATABASE_EVENT_LISTENER");
        Set.setType(16, "MAX_MEMORY_ROWS");
        Set.setType(17, "LOCK_MODE");
        Set.setType(18, "ASSERT");
        Set.setType(19, "DB_CLOSE_DELAY");
        Set.setType(20, "LOG");
        Set.setType(21, "THROTTLE");
        Set.setType(22, "MAX_MEMORY_UNDO");
        Set.setType(23, "MAX_LENGTH_INPLACE_LOB");
        Set.setType(24, "COMPRESS_LOB");
        Set.setType(25, "ALLOW_LITERALS");
        Set.setType(26, "MULTI_THREADED");
    }
}

