/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.table.Column;
import org.h2.table.Table;
import org.h2.util.ObjectArray;

public class AlterTableRenameColumn
extends DefineCommand {
    private Table table;
    private Column column;
    private String newName;

    public AlterTableRenameColumn(Session session) {
        super(session);
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public void setNewColumnName(String newName) {
        this.newName = newName;
    }

    public int update() throws SQLException {
        this.session.commit();
        Database db = this.session.getDatabase();
        this.session.getUser().checkRight(this.table, 15);
        this.table.checkSupportAlter();
        this.table.renameColumn(this.column, this.newName);
        this.table.setModified();
        db.update(this.session, this.table);
        ObjectArray children = this.table.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            DbObject child = (DbObject)children.get(i);
            if (child.getCreateSQL() == null) continue;
            db.update(this.session, child);
        }
        return 0;
    }
}

