/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.engine.Database;
import org.h2.engine.DbObject;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.Message;
import org.h2.table.Table;
import org.h2.util.TypeConverter;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueNull;

public class FunctionAlias
extends DbObject {
    private String className;
    private String methodName;
    private Method javaMethod;
    private int paramCount;
    private boolean hasConnectionParam;
    private int dataType;
    static /* synthetic */ Class class$java$sql$Connection;

    public FunctionAlias(Database db, int id, String name, String javaClassMethod) throws SQLException {
        super(db, id, name, "function");
        Class<?> paramClass;
        Class<?> javaClass;
        int paren = javaClassMethod.indexOf(40);
        int lastDot = javaClassMethod.lastIndexOf(46, paren < 0 ? javaClassMethod.length() : paren);
        if (lastDot < 0) {
            throw Message.getSQLException(42000, javaClassMethod);
        }
        this.className = javaClassMethod.substring(0, lastDot);
        this.methodName = javaClassMethod.substring(lastDot + 1);
        try {
            javaClass = Class.forName(this.className);
        }
        catch (ClassNotFoundException e) {
            throw Message.getSQLException(90086, new String[]{this.className + " (" + this.methodName + ")"}, e);
        }
        Method[] methods = javaClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!Modifier.isStatic(m.getModifiers())) continue;
            if (m.getName().equals(this.methodName)) {
                this.javaMethod = m;
                break;
            }
            if (!this.getMethodSignature(m).equals(this.methodName)) continue;
            this.javaMethod = m;
            break;
        }
        if (this.javaMethod == null) {
            throw Message.getSQLException(90087, this.methodName + " (" + this.className + ")");
        }
        Class<?>[] paramClasses = this.javaMethod.getParameterTypes();
        this.paramCount = paramClasses.length;
        if (this.paramCount > 0 && (class$java$sql$Connection == null ? (class$java$sql$Connection = FunctionAlias.class$("java.sql.Connection")) : class$java$sql$Connection).isAssignableFrom(paramClass = paramClasses[0])) {
            this.hasConnectionParam = true;
            --this.paramCount;
        }
        Class<?> returnClass = this.javaMethod.getReturnType();
        this.dataType = DataType.getTypeFromClass(returnClass);
    }

    private String getMethodSignature(Method m) {
        StringBuffer buff = new StringBuffer();
        buff.append(m.getName());
        buff.append('(');
        Class<?>[] params = m.getParameterTypes();
        for (int i = 0; i < params.length; ++i) {
            Class<?> p;
            if (i > 0) {
                buff.append(", ");
            }
            if ((p = params[i]).isArray()) {
                buff.append(p.getComponentType().getName());
                buff.append("[]");
                continue;
            }
            buff.append(p.getName());
        }
        buff.append(')');
        return buff.toString();
    }

    public Class[] getColumnClasses() {
        return this.javaMethod.getParameterTypes();
    }

    public int getDataType() {
        return this.dataType;
    }

    public String getCreateSQLForCopy(Table table, String quotedName) {
        throw Message.internal();
    }

    public String getCreateSQL() {
        StringBuffer buff = new StringBuffer();
        buff.append("CREATE ALIAS ");
        buff.append(this.getSQL());
        buff.append(" FOR ");
        buff.append(Parser.quoteIdentifier(this.className + "." + this.methodName));
        return buff.toString();
    }

    public int getType() {
        return 9;
    }

    public void removeChildrenAndResources(Session session) throws SQLException {
        this.methodName = null;
        this.className = null;
        this.javaMethod = null;
        this.invalidate();
    }

    public void checkRename() throws SQLException {
        throw Message.getUnsupportedException();
    }

    public Value getValue(Session session, Expression[] args) throws SQLException {
        return this.getValue(session, args, false);
    }

    private JdbcConnection createConnection(Session session) throws SQLException {
        return new JdbcConnection(session, session.getUser().getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Value getValue(Session session, Expression[] args, boolean setNullPrimitivesToDefault) throws SQLException {
        FunctionAlias functionAlias = this;
        synchronized (functionAlias) {
            Class<?>[] paramClasses = this.javaMethod.getParameterTypes();
            Object[] params = new Object[paramClasses.length];
            int p = 0;
            if (this.hasConnectionParam && params.length > 0) {
                params[p++] = this.createConnection(session);
            }
            for (int a = 0; a < args.length && p < params.length; ++a, ++p) {
                Class<?> paramClass = paramClasses[p];
                int type = DataType.getTypeFromClass(paramClass);
                Value v = args[a].getValue(session);
                Object o = (v = v.convertTo(type)).getObject();
                if (o == null) {
                    if (paramClass.isPrimitive()) {
                        if (!setNullPrimitivesToDefault) {
                            return ValueNull.INSTANCE;
                        }
                        o = TypeConverter.getDefaultForPrimitiveType(paramClass);
                    }
                } else if (!paramClass.isAssignableFrom(o.getClass()) && !paramClass.isPrimitive()) {
                    o = TypeConverter.convertTo(session, this.createConnection(session), v, paramClass);
                }
                params[p] = o;
            }
            boolean old = session.getAutoCommit();
            try {
                Object returnValue;
                block16: {
                    ValueNull type;
                    session.setAutoCommit(false);
                    try {
                        returnValue = this.javaMethod.invoke(null, params);
                        if (returnValue != null) break block16;
                        type = ValueNull.INSTANCE;
                    }
                    catch (Exception e) {
                        throw Message.convert(e);
                    }
                    return type;
                }
                Value ret = session.convertToValue(returnValue);
                Value value = ret.convertTo(this.dataType);
                return value;
            }
            finally {
                session.setAutoCommit(old);
            }
        }
    }

    public int getParameterCount() {
        return this.paramCount;
    }

    public String getJavaClassName() {
        return this.className;
    }

    public String getJavaMethodName() {
        return this.methodName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

