/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.h2.engine.Database;
import org.h2.engine.Session;
import org.h2.expression.ExpressionColumn;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.table.Column;
import org.h2.util.ObjectArray;
import org.h2.value.CompareMode;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueArray;

public class ValueResultSet
extends Value {
    private LocalResult result;

    public static ValueResultSet get(Session session, ResultSet rs, int maxrows) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        ObjectArray cols = new ObjectArray();
        int[] types = new int[columnCount];
        Database db = session == null ? null : session.getDatabase();
        for (int i = 0; i < columnCount; ++i) {
            int type;
            String name = meta.getColumnLabel(i + 1);
            types[i] = type = DataType.convertSQLTypeToValueType(meta.getColumnType(i + 1));
            int precision = meta.getPrecision(i + 1);
            int scale = meta.getScale(i + 1);
            Column col = new Column(name, type, precision, scale);
            ExpressionColumn expr = new ExpressionColumn(db, null, col);
            cols.add(expr);
        }
        ValueResultSet val = new ValueResultSet();
        val.result = new LocalResult(session, cols, columnCount);
        for (int i = 0; i < maxrows && rs.next(); ++i) {
            Value[] list = new Value[columnCount];
            for (int j = 0; j < columnCount; ++j) {
                list[j] = DataType.readValue(session, rs, j + 1, types[j]);
            }
            val.result.addRow(list);
        }
        val.result.done();
        return val;
    }

    public int getType() {
        return 18;
    }

    public long getPrecision() {
        return 0L;
    }

    public int getDisplaySize() {
        return 100;
    }

    public String getString() throws SQLException {
        StringBuffer buff = new StringBuffer();
        buff.append("(");
        this.result.reset();
        int i = 0;
        while (this.result.next()) {
            if (i > 0) {
                buff.append(", ");
            }
            ++i;
            Value[] list = this.result.currentRow();
            buff.append(ValueArray.get(list).getString());
        }
        buff.append(")");
        return buff.toString();
    }

    protected int compareSecure(Value v, CompareMode mode) throws SQLException {
        throw Message.getUnsupportedException();
    }

    protected boolean isEqual(Value v) {
        return false;
    }

    public Object getObject() throws SQLException {
        return this.result;
    }

    public LocalResult getResult() throws SQLException {
        return this.result;
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        throw Message.getUnsupportedException();
    }

    public String getSQL() {
        return "";
    }
}

