/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.h2.engine.Session;
import org.h2.jdbc.JdbcBlob;
import org.h2.jdbc.JdbcClob;
import org.h2.jdbc.JdbcConnection;
import org.h2.jdbc.JdbcSQLException;
import org.h2.message.Message;
import org.h2.util.ReaderInputStream;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueDate;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

public class TypeConverter {
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$sql$Clob;

    public static Object getDefaultForPrimitiveType(Class clazz) {
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Byte.TYPE) {
            return new Byte(0);
        }
        if (clazz == Character.TYPE) {
            return new Character('\u0000');
        }
        if (clazz == Short.TYPE) {
            return new Short(0);
        }
        if (clazz == Integer.TYPE) {
            return new Integer(0);
        }
        if (clazz == Long.TYPE) {
            return new Long(0L);
        }
        if (clazz == Float.TYPE) {
            return new Float(0.0f);
        }
        if (clazz == Double.TYPE) {
            return new Double(0.0);
        }
        throw Message.internal("primitive=" + clazz.toString());
    }

    public static byte[] serialize(Object obj) throws SQLException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(out);
            os.writeObject(obj);
            return out.toByteArray();
        }
        catch (Throwable e) {
            throw Message.getSQLException(90026, null, e);
        }
    }

    public static Object deserialize(byte[] data) throws SQLException {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            ObjectInputStream is = new ObjectInputStream(in);
            Object obj = is.readObject();
            return obj;
        }
        catch (Throwable e) {
            throw Message.getSQLException(90027, null, e);
        }
    }

    public static Reader getReader(InputStream in) throws SQLException {
        try {
            return new BufferedReader(new InputStreamReader(in, "UTF8"), 4096);
        }
        catch (UnsupportedEncodingException e) {
            throw Message.convert(e);
        }
    }

    public static InputStream getInputStream(String s) throws SQLException {
        return new ByteArrayInputStream(StringUtils.utf8Encode(s));
    }

    public static InputStream getInputStream(Reader x) throws SQLException {
        return new ReaderInputStream(x);
    }

    public static Reader getReader(String s) {
        return new StringReader(s);
    }

    public static Date convertDateToCalendar(Date x, Calendar calendar) throws SQLException {
        return x == null ? x : new Date(TypeConverter.getLocalTime(x, calendar));
    }

    public static Time convertTimeToCalendar(Time x, Calendar calendar) throws SQLException {
        return x == null ? x : new Time(TypeConverter.getLocalTime(x, calendar));
    }

    public static Timestamp convertTimestampToCalendar(Timestamp x, Calendar calendar) throws SQLException {
        if (x != null) {
            Timestamp y = new Timestamp(TypeConverter.getLocalTime(x, calendar));
            y.setNanos(x.getNanos());
            x = y;
        }
        return x;
    }

    public static Value convertDateToUniversal(Date x, Calendar source) throws SQLException {
        return ValueDate.get(new Date(TypeConverter.getUniversalTime(source, x)));
    }

    public static Value convertTimeToUniversal(Time x, Calendar source) throws SQLException {
        return ValueTime.get(new Time(TypeConverter.getUniversalTime(source, x)));
    }

    public static Value convertTimestampToUniversal(Timestamp x, Calendar source) throws SQLException {
        Timestamp y = new Timestamp(TypeConverter.getUniversalTime(source, x));
        y.setNanos(x.getNanos());
        return ValueTimestamp.get(y);
    }

    private static long getUniversalTime(Calendar source, java.util.Date x) throws SQLException {
        if (source == null) {
            throw Message.getInvalidValueException("calendar", null);
        }
        source = (Calendar)source.clone();
        Calendar universal = Calendar.getInstance();
        source.setTime(x);
        TypeConverter.convertTime(source, universal);
        return universal.getTime().getTime();
    }

    private static long getLocalTime(java.util.Date x, Calendar target) throws SQLException {
        if (target == null) {
            throw Message.getInvalidValueException("calendar", null);
        }
        target = (Calendar)target.clone();
        Calendar local = Calendar.getInstance();
        local.setTime(x);
        TypeConverter.convertTime(local, target);
        return target.getTime().getTime();
    }

    private static void convertTime(Calendar from, Calendar to) {
        to.set(1, from.get(1));
        to.set(2, from.get(2));
        to.set(5, from.get(5));
        to.set(11, from.get(11));
        to.set(12, from.get(12));
        to.set(13, from.get(13));
        to.set(14, from.get(14));
    }

    public static Reader getAsciiReader(InputStream x) throws SQLException {
        try {
            return new InputStreamReader(x, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw Message.convert(e);
        }
    }

    public static Object convertTo(Session session, JdbcConnection conn, Value v, Class paramClass) throws JdbcSQLException {
        if (paramClass == (class$java$sql$Blob == null ? (class$java$sql$Blob = TypeConverter.class$("java.sql.Blob")) : class$java$sql$Blob)) {
            return new JdbcBlob(session, conn, v, 0);
        }
        if (paramClass == (class$java$sql$Clob == null ? (class$java$sql$Clob = TypeConverter.class$("java.sql.Clob")) : class$java$sql$Clob)) {
            return new JdbcClob(session, conn, v, 0);
        }
        throw Message.getUnsupportedException();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

