/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools.doclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.Parameter;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import com.sun.javadoc.Type;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;

public class Doclet {
    public static boolean start(RootDoc root) throws IOException {
        int i;
        ClassDoc[] classes = root.classes();
        String[][] options = root.options();
        String destDir = "docs/javadoc";
        for (i = 0; i < options.length; ++i) {
            if (!options[i][0].equals("destdir")) continue;
            destDir = options[i][1];
        }
        for (i = 0; i < classes.length; ++i) {
            ClassDoc clazz = classes[i];
            Doclet.processClass(destDir, clazz);
        }
        return true;
    }

    private static String getClass(String name) {
        if (name.startsWith("Jdbc")) {
            return name.substring(4);
        }
        return name;
    }

    private static void processClass(String destDir, ClassDoc clazz) throws IOException {
        String type;
        String name;
        int i;
        String firstSentence;
        String packageName = clazz.containingPackage().name();
        String dir = destDir + "/" + packageName.replace('.', '/');
        new File(dir).mkdirs();
        String fileName = dir + "/" + clazz.name() + ".html";
        String className = Doclet.getClass(clazz.name());
        FileWriter out = new FileWriter(fileName);
        PrintWriter writer = new PrintWriter(new BufferedWriter(out));
        writer.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        writer.println("<html><head><meta http-equiv=\"Content-Type\" content=\"text/html;charset=utf-8\"><title>");
        writer.println(className);
        writer.println("</title><link rel=\"stylesheet\" type=\"text/css\" href=\"../../../stylesheet.css\">");
        writer.println("<script type=\"text/javascript\" src=\"../../../../html/navigation.js\"></script>");
        writer.println("</head><body onload=\"frameMe();\">");
        writer.println("<table class=\"content\"><tr class=\"content\"><td class=\"content\"><div class=\"contentDiv\">");
        writer.println("<h1>" + className + "</h1>");
        writer.println("<p>" + clazz.commentText() + "</p>");
        MethodDoc[] methods = clazz.methods();
        Arrays.sort(methods, new Comparator(){

            public int compare(Object a, Object b) {
                return ((MethodDoc)a).name().compareTo(((MethodDoc)b).name());
            }
        });
        writer.println("<table><tr><th colspan=\"2\">Methods</th></tr>");
        for (int i2 = 0; i2 < methods.length; ++i2) {
            MethodDoc method = methods[i2];
            String name2 = method.name();
            if (Doclet.skipMethod(method)) continue;
            String type2 = Doclet.getTypeName(method.returnType());
            writer.println("<tr><td class=\"return\">" + type2 + "</td><td class=\"method\">");
            Parameter[] params = method.parameters();
            StringBuffer buff = new StringBuffer();
            buff.append('(');
            for (int j = 0; j < params.length; ++j) {
                if (j > 0) {
                    buff.append(", ");
                }
                buff.append(Doclet.getTypeName(params[j].type()));
                buff.append(' ');
                buff.append(params[j].name());
            }
            buff.append(')');
            if (Doclet.isDeprecated(method)) {
                name2 = "<span class=\"deprecated\">" + name2 + "</span>";
            }
            writer.println("<a href=\"#r" + i2 + "\">" + name2 + "</a>" + buff.toString());
            firstSentence = Doclet.getFirstSentence(method.firstSentenceTags());
            if (firstSentence != null) {
                writer.println("<div class=\"methodText\">" + firstSentence + "</div>");
            }
            writer.println("</td></tr>");
        }
        writer.println("</table>");
        FieldDoc[] fields = clazz.fields();
        if (clazz.interfaces().length > 0) {
            fields = clazz.interfaces()[0].fields();
        }
        Arrays.sort(fields, new Comparator(){

            public int compare(Object a, Object b) {
                return ((FieldDoc)a).name().compareTo(((FieldDoc)b).name());
            }
        });
        int fieldId = 0;
        for (i = 0; i < fields.length; ++i) {
            FieldDoc field = fields[i];
            if (!field.isFinal() || !field.isStatic() || !field.isPublic()) continue;
            if (fieldId == 0) {
                writer.println("<p></p><table><tr><th colspan=\"2\">Fields</th></tr>");
            }
            name = field.name();
            type = "static " + Doclet.getTypeName(field.type());
            writer.println("<tr><td class=\"return\">" + type + "</td><td class=\"method\">");
            writer.println(name + " = " + field.constantValueExpression());
            firstSentence = Doclet.getFirstSentence(field.firstSentenceTags());
            if (firstSentence != null) {
                writer.println("<div class=\"methodText\">" + firstSentence + "</div>");
            }
            writer.println("</td></tr>");
            ++fieldId;
        }
        if (fieldId > 0) {
            writer.println("</table>");
        }
        for (i = 0; i < methods.length; ++i) {
            ThrowsTag[] throwsTags;
            MethodDoc method = methods[i];
            name = method.name();
            if (Doclet.skipMethod(method)) continue;
            type = Doclet.getTypeName(method.returnType());
            writer.println("<a name=\"r" + i + "\"></a>");
            Parameter[] params = method.parameters();
            StringBuffer buff = new StringBuffer();
            buff.append('(');
            for (int j = 0; j < params.length; ++j) {
                if (j > 0) {
                    buff.append(", ");
                }
                buff.append(Doclet.getTypeName(params[j].type()));
                buff.append(' ');
                buff.append(params[j].name());
            }
            buff.append(')');
            ClassDoc[] exceptions = method.thrownExceptions();
            if (exceptions.length > 0) {
                buff.append(" throws ");
                for (int k = 0; k < exceptions.length; ++k) {
                    if (k > 0) {
                        buff.append(", ");
                    }
                    buff.append(exceptions[k].typeName());
                }
            }
            if (Doclet.isDeprecated(method)) {
                name = "<span class=\"deprecated\">" + name + "</span>";
            }
            writer.println("<h4>" + type + " <span class=\"methodName\">" + name + "</span>" + buff.toString() + "</h4>");
            writer.println("<p>" + method.commentText() + "</p>");
            ParamTag[] paramTags = method.paramTags();
            for (int j = 0; j < paramTags.length; ++j) {
                String p = paramTags[j].parameterName() + " - " + paramTags[j].parameterComment();
                if (j == 0) {
                    writer.println("<div class=\"itemTitle\">Parameters:</div>");
                }
                writer.println("<div class=\"item\">" + p + "</div>");
            }
            Tag[] returnTags = method.tags("return");
            if (returnTags != null && returnTags.length > 0) {
                writer.println("<div class=\"itemTitle\">Returns:</div>");
                writer.println("<div class=\"item\">" + returnTags[0].text() + "</div>");
            }
            if ((throwsTags = method.throwsTags()) != null && throwsTags.length > 0) {
                writer.println("<div class=\"itemTitle\">Throws:</div>");
                for (int j = 0; j < throwsTags.length; ++j) {
                    String p = throwsTags[j].exceptionName() + " - " + throwsTags[j].exceptionComment();
                    writer.println("<div class=\"item\">" + p + "</div>");
                }
            }
            writer.println("<hr>");
        }
        writer.println("</div></td></tr></table></body></html>");
        writer.close();
        out.close();
    }

    private static boolean skipMethod(MethodDoc method) {
        String name = method.name();
        if (!method.isPublic() || name.equals("finalize")) {
            return true;
        }
        if (method.getRawCommentText().startsWith("@deprecated INTERNAL")) {
            return true;
        }
        String firstSentence = Doclet.getFirstSentence(method.firstSentenceTags());
        if (firstSentence == null || firstSentence.trim().length() == 0) {
            throw new Error("undocumented method? " + name + " " + method.containingClass().name() + " " + method.getRawCommentText());
        }
        return firstSentence.startsWith("INTERNAL");
    }

    private static String getFirstSentence(Tag[] tags) {
        String firstSentence = null;
        if (tags.length > 0) {
            Tag first = tags[0];
            firstSentence = first.text();
        }
        return firstSentence;
    }

    private static String getTypeName(Type type) {
        return type.typeName() + type.dimension();
    }

    private static boolean isDeprecated(MethodDoc method) {
        Tag[] tags = method.tags();
        boolean deprecated = false;
        for (int j = 0; j < tags.length; ++j) {
            Tag t = tags[j];
            if (!t.kind().equals("@deprecated")) continue;
            deprecated = true;
        }
        return deprecated;
    }
}

