/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools.code;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import org.h2.tools.code.CheckTextFiles;
import org.h2.util.IOUtils;
import org.h2.util.StringUtils;
import org.h2.web.PageParser;

public class PropertiesToUTF8 {
    public static void main(String[] args) throws Exception {
        File[] list = new File("bin/org/h2/web/res").listFiles();
        for (int i = 0; i < list.length; ++i) {
            Closeable out;
            File f = list[i];
            if (!f.getName().endsWith(".properties")) continue;
            FileInputStream in = new FileInputStream(f);
            InputStreamReader r = new InputStreamReader((InputStream)in, "UTF-8");
            String s = IOUtils.readStringAndClose(r, -1);
            in.close();
            String name = f.getName();
            if (name.startsWith("utf8")) {
                s = PageParser.escapeHtml(s, false);
                out = new RandomAccessFile(name.substring(4), "rw");
                ((RandomAccessFile)out).write(s.getBytes());
                ((RandomAccessFile)out).close();
                continue;
            }
            new CheckTextFiles().checkOrFixFile(f, false, false);
            s = PropertiesToUTF8.unescapeHtml(s);
            s = StringUtils.javaDecode(s);
            out = new FileOutputStream("utf8" + f.getName());
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, "UTF-8");
            w.write(s);
            w.close();
            ((FileOutputStream)out).close();
        }
    }

    private static String unescapeHtml(String s) {
        String codes = "&lt; < &amp; & &gt; > &Auml; \u00c4 &Ouml; \u00d6 &Uuml; \u00dc &auml; \u00e4 &ouml; \u00f6 &uuml; \u00fc &ntilde; \u00f1 &oacute; \u00f3 &Iacute; \u00cd &ccedil; \u00e7 &eagrave; \u00e8 &ecirc; \u00ea &Uacute; \u00da &aacute; \u00e1 &uacute; \u00fa &eacute; \u00e9 &egrave; \u00e8 &icirc; \u00ee";
        String[] list = StringUtils.arraySplit(codes, ' ', false);
        for (int i = 0; i < list.length; i += 2) {
            s = StringUtils.replaceAll(s, list[i], list[i + 1]);
        }
        if (s.indexOf("&") >= 0) {
            throw new Error("??? " + s);
        }
        return s;
    }
}

